@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an Infrastructure Performance subscription.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.VpcNetworkPerformanceMetricSubscription("example", {
 *     source: "us-east-1",
 *     destination: "us-west-1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.VpcNetworkPerformanceMetricSubscription("example",
 *     source="us-east-1",
 *     destination="us-west-1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.VpcNetworkPerformanceMetricSubscription("example", new()
 *     {
 *         Source = "us-east-1",
 *         Destination = "us-west-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcNetworkPerformanceMetricSubscription(ctx, "example", &ec2.VpcNetworkPerformanceMetricSubscriptionArgs{
 * 			Source:      pulumi.String("us-east-1"),
 * 			Destination: pulumi.String("us-west-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscription;
 * import com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcNetworkPerformanceMetricSubscription("example", VpcNetworkPerformanceMetricSubscriptionArgs.builder()
 *             .source("us-east-1")
 *             .destination("us-west-1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcNetworkPerformanceMetricSubscription
 *     properties:
 *       source: us-east-1
 *       destination: us-west-1
 * ```
 * <!--End PulumiCodeChooser -->
 * @property destination The target Region or Availability Zone that the metric subscription is enabled for. For example, `eu-west-1`.
 * @property metric The metric used for the enabled subscription. Valid values: `aggregate-latency`. Default: `aggregate-latency`.
 * @property source The source Region or Availability Zone that the metric subscription is enabled for. For example, `us-east-1`.
 * @property statistic The statistic used for the enabled subscription. Valid values: `p50`. Default: `p50`.
 */
public data class VpcNetworkPerformanceMetricSubscriptionArgs(
    public val destination: Output<String>? = null,
    public val metric: Output<String>? = null,
    public val source: Output<String>? = null,
    public val statistic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs =
        com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .metric(metric?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .statistic(statistic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcNetworkPerformanceMetricSubscriptionArgs].
 */
@PulumiTagMarker
public class VpcNetworkPerformanceMetricSubscriptionArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var metric: Output<String>? = null

    private var source: Output<String>? = null

    private var statistic: Output<String>? = null

    /**
     * @param value The target Region or Availability Zone that the metric subscription is enabled for. For example, `eu-west-1`.
     */
    @JvmName("wvadxdkciqdbowti")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value The metric used for the enabled subscription. Valid values: `aggregate-latency`. Default: `aggregate-latency`.
     */
    @JvmName("tdcraedjrlmsgpnp")
    public suspend fun metric(`value`: Output<String>) {
        this.metric = value
    }

    /**
     * @param value The source Region or Availability Zone that the metric subscription is enabled for. For example, `us-east-1`.
     */
    @JvmName("eotqfyaylbvjdwkk")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The statistic used for the enabled subscription. Valid values: `p50`. Default: `p50`.
     */
    @JvmName("cothufylwrmlbwlg")
    public suspend fun statistic(`value`: Output<String>) {
        this.statistic = value
    }

    /**
     * @param value The target Region or Availability Zone that the metric subscription is enabled for. For example, `eu-west-1`.
     */
    @JvmName("yhqeipaijiethhba")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The metric used for the enabled subscription. Valid values: `aggregate-latency`. Default: `aggregate-latency`.
     */
    @JvmName("ueadncfsfykkvquo")
    public suspend fun metric(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param value The source Region or Availability Zone that the metric subscription is enabled for. For example, `us-east-1`.
     */
    @JvmName("ppoemiuykqyqsdul")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The statistic used for the enabled subscription. Valid values: `p50`. Default: `p50`.
     */
    @JvmName("twpgeiybbbejroiq")
    public suspend fun statistic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistic = mapped
    }

    internal fun build(): VpcNetworkPerformanceMetricSubscriptionArgs =
        VpcNetworkPerformanceMetricSubscriptionArgs(
            destination = destination,
            metric = metric,
            source = source,
            statistic = statistic,
        )
}
