@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpnConnectionRoute
import com.pulumi.aws.ec2.kotlin.outputs.VpnConnectionTunnel1LogOptions
import com.pulumi.aws.ec2.kotlin.outputs.VpnConnectionTunnel2LogOptions
import com.pulumi.aws.ec2.kotlin.outputs.VpnConnectionVgwTelemetry
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.VpnConnectionRoute.Companion.toKotlin as vpnConnectionRouteToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.VpnConnectionTunnel1LogOptions.Companion.toKotlin as vpnConnectionTunnel1LogOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.VpnConnectionTunnel2LogOptions.Companion.toKotlin as vpnConnectionTunnel2LogOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.VpnConnectionVgwTelemetry.Companion.toKotlin as vpnConnectionVgwTelemetryToKotlin

/**
 * Builder for [VpnConnection].
 */
@PulumiTagMarker
public class VpnConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnConnectionArgs = VpnConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnConnectionArgsBuilder.() -> Unit) {
        val builder = VpnConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpnConnection {
        val builtJavaResource = com.pulumi.aws.ec2.VpnConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpnConnection(builtJavaResource)
    }
}

/**
 * Manages a Site-to-Site VPN connection. A Site-to-Site VPN connection is an Internet Protocol security (IPsec) VPN connection between a VPC and an on-premises network.
 * Any new Site-to-Site VPN connection that you create is an [AWS VPN connection](https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-categories.html).
 * > **Note:** The CIDR blocks in the arguments `tunnel1_inside_cidr` and `tunnel2_inside_cidr` must have a prefix of /30 and be a part of a specific range.
 * [Read more about this in the AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnTunnelOptionsSpecification.html).
 * ## Example Usage
 * ### EC2 Transit Gateway
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.TransitGateway("example", {});
 * const exampleCustomerGateway = new aws.ec2.CustomerGateway("example", {
 *     bgpAsn: "65000",
 *     ipAddress: "172.0.0.1",
 *     type: "ipsec.1",
 * });
 * const exampleVpnConnection = new aws.ec2.VpnConnection("example", {
 *     customerGatewayId: exampleCustomerGateway.id,
 *     transitGatewayId: example.id,
 *     type: exampleCustomerGateway.type,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.TransitGateway("example")
 * example_customer_gateway = aws.ec2.CustomerGateway("example",
 *     bgp_asn="65000",
 *     ip_address="172.0.0.1",
 *     type="ipsec.1")
 * example_vpn_connection = aws.ec2.VpnConnection("example",
 *     customer_gateway_id=example_customer_gateway.id,
 *     transit_gateway_id=example.id,
 *     type=example_customer_gateway.type)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.TransitGateway("example");
 *     var exampleCustomerGateway = new Aws.Ec2.CustomerGateway("example", new()
 *     {
 *         BgpAsn = "65000",
 *         IpAddress = "172.0.0.1",
 *         Type = "ipsec.1",
 *     });
 *     var exampleVpnConnection = new Aws.Ec2.VpnConnection("example", new()
 *     {
 *         CustomerGatewayId = exampleCustomerGateway.Id,
 *         TransitGatewayId = example.Id,
 *         Type = exampleCustomerGateway.Type,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2transitgateway.NewTransitGateway(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleCustomerGateway, err := ec2.NewCustomerGateway(ctx, "example", &ec2.CustomerGatewayArgs{
 * 			BgpAsn:    pulumi.String("65000"),
 * 			IpAddress: pulumi.String("172.0.0.1"),
 * 			Type:      pulumi.String("ipsec.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpnConnection(ctx, "example", &ec2.VpnConnectionArgs{
 * 			CustomerGatewayId: exampleCustomerGateway.ID(),
 * 			TransitGatewayId:  example.ID(),
 * 			Type:              exampleCustomerGateway.Type,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGateway("example");
 *         var exampleCustomerGateway = new CustomerGateway("exampleCustomerGateway", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.0.0.1")
 *             .type("ipsec.1")
 *             .build());
 *         var exampleVpnConnection = new VpnConnection("exampleVpnConnection", VpnConnectionArgs.builder()
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .transitGatewayId(example.id())
 *             .type(exampleCustomerGateway.type())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:TransitGateway
 *   exampleCustomerGateway:
 *     type: aws:ec2:CustomerGateway
 *     name: example
 *     properties:
 *       bgpAsn: 65000
 *       ipAddress: 172.0.0.1
 *       type: ipsec.1
 *   exampleVpnConnection:
 *     type: aws:ec2:VpnConnection
 *     name: example
 *     properties:
 *       customerGatewayId: ${exampleCustomerGateway.id}
 *       transitGatewayId: ${example.id}
 *       type: ${exampleCustomerGateway.type}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Virtual Private Gateway
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const vpc = new aws.ec2.Vpc("vpc", {cidrBlock: "10.0.0.0/16"});
 * const vpnGateway = new aws.ec2.VpnGateway("vpn_gateway", {vpcId: vpc.id});
 * const customerGateway = new aws.ec2.CustomerGateway("customer_gateway", {
 *     bgpAsn: "65000",
 *     ipAddress: "172.0.0.1",
 *     type: "ipsec.1",
 * });
 * const main = new aws.ec2.VpnConnection("main", {
 *     vpnGatewayId: vpnGateway.id,
 *     customerGatewayId: customerGateway.id,
 *     type: "ipsec.1",
 *     staticRoutesOnly: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * vpc = aws.ec2.Vpc("vpc", cidr_block="10.0.0.0/16")
 * vpn_gateway = aws.ec2.VpnGateway("vpn_gateway", vpc_id=vpc.id)
 * customer_gateway = aws.ec2.CustomerGateway("customer_gateway",
 *     bgp_asn="65000",
 *     ip_address="172.0.0.1",
 *     type="ipsec.1")
 * main = aws.ec2.VpnConnection("main",
 *     vpn_gateway_id=vpn_gateway.id,
 *     customer_gateway_id=customer_gateway.id,
 *     type="ipsec.1",
 *     static_routes_only=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpc = new Aws.Ec2.Vpc("vpc", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var vpnGateway = new Aws.Ec2.VpnGateway("vpn_gateway", new()
 *     {
 *         VpcId = vpc.Id,
 *     });
 *     var customerGateway = new Aws.Ec2.CustomerGateway("customer_gateway", new()
 *     {
 *         BgpAsn = "65000",
 *         IpAddress = "172.0.0.1",
 *         Type = "ipsec.1",
 *     });
 *     var main = new Aws.Ec2.VpnConnection("main", new()
 *     {
 *         VpnGatewayId = vpnGateway.Id,
 *         CustomerGatewayId = customerGateway.Id,
 *         Type = "ipsec.1",
 *         StaticRoutesOnly = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		vpc, err := ec2.NewVpc(ctx, "vpc", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vpnGateway, err := ec2.NewVpnGateway(ctx, "vpn_gateway", &ec2.VpnGatewayArgs{
 * 			VpcId: vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		customerGateway, err := ec2.NewCustomerGateway(ctx, "customer_gateway", &ec2.CustomerGatewayArgs{
 * 			BgpAsn:    pulumi.String("65000"),
 * 			IpAddress: pulumi.String("172.0.0.1"),
 * 			Type:      pulumi.String("ipsec.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpnConnection(ctx, "main", &ec2.VpnConnectionArgs{
 * 			VpnGatewayId:      vpnGateway.ID(),
 * 			CustomerGatewayId: customerGateway.ID(),
 * 			Type:              pulumi.String("ipsec.1"),
 * 			StaticRoutesOnly:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Vpc("vpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var vpnGateway = new VpnGateway("vpnGateway", VpnGatewayArgs.builder()
 *             .vpcId(vpc.id())
 *             .build());
 *         var customerGateway = new CustomerGateway("customerGateway", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.0.0.1")
 *             .type("ipsec.1")
 *             .build());
 *         var main = new VpnConnection("main", VpnConnectionArgs.builder()
 *             .vpnGatewayId(vpnGateway.id())
 *             .customerGatewayId(customerGateway.id())
 *             .type("ipsec.1")
 *             .staticRoutesOnly(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpc:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   vpnGateway:
 *     type: aws:ec2:VpnGateway
 *     name: vpn_gateway
 *     properties:
 *       vpcId: ${vpc.id}
 *   customerGateway:
 *     type: aws:ec2:CustomerGateway
 *     name: customer_gateway
 *     properties:
 *       bgpAsn: 65000
 *       ipAddress: 172.0.0.1
 *       type: ipsec.1
 *   main:
 *     type: aws:ec2:VpnConnection
 *     properties:
 *       vpnGatewayId: ${vpnGateway.id}
 *       customerGatewayId: ${customerGateway.id}
 *       type: ipsec.1
 *       staticRoutesOnly: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### AWS Site to Site Private VPN
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleGateway = new aws.directconnect.Gateway("example", {
 *     name: "example_ipsec_vpn_example",
 *     amazonSideAsn: "64512",
 * });
 * const exampleTransitGateway = new aws.ec2transitgateway.TransitGateway("example", {
 *     amazonSideAsn: 64513,
 *     description: "example_ipsec_vpn_example",
 *     transitGatewayCidrBlocks: ["10&#46;0&#46;0&#46;0/24"],
 * });
 * const exampleCustomerGateway = new aws.ec2.CustomerGateway("example", {
 *     bgpAsn: "64514",
 *     ipAddress: "10.0.0.1",
 *     type: "ipsec.1",
 *     tags: {
 *         Name: "example_ipsec_vpn_example",
 *     },
 * });
 * const exampleGatewayAssociation = new aws.directconnect.GatewayAssociation("example", {
 *     dxGatewayId: exampleGateway.id,
 *     associatedGatewayId: exampleTransitGateway.id,
 *     allowedPrefixes: ["10&#46;0&#46;0&#46;0/8"],
 * });
 * const example = aws.ec2transitgateway.getDirectConnectGatewayAttachmentOutput({
 *     transitGatewayId: exampleTransitGateway.id,
 *     dxGatewayId: exampleGateway.id,
 * });
 * const exampleVpnConnection = new aws.ec2.VpnConnection("example", {
 *     customerGatewayId: exampleCustomerGateway.id,
 *     outsideIpAddressType: "PrivateIpv4",
 *     transitGatewayId: exampleTransitGateway.id,
 *     transportTransitGatewayAttachmentId: example.apply(example => example.id),
 *     type: "ipsec.1",
 *     tags: {
 *         Name: "example_ipsec_vpn_example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_gateway = aws.directconnect.Gateway("example",
 *     name="example_ipsec_vpn_example",
 *     amazon_side_asn="64512")
 * example_transit_gateway = aws.ec2transitgateway.TransitGateway("example",
 *     amazon_side_asn=64513,
 *     description="example_ipsec_vpn_example",
 *     transit_gateway_cidr_blocks=["10&#46;0&#46;0&#46;0/24"])
 * example_customer_gateway = aws.ec2.CustomerGateway("example",
 *     bgp_asn="64514",
 *     ip_address="10.0.0.1",
 *     type="ipsec.1",
 *     tags={
 *         "Name": "example_ipsec_vpn_example",
 *     })
 * example_gateway_association = aws.directconnect.GatewayAssociation("example",
 *     dx_gateway_id=example_gateway.id,
 *     associated_gateway_id=example_transit_gateway.id,
 *     allowed_prefixes=["10&#46;0&#46;0&#46;0/8"])
 * example = aws.ec2transitgateway.get_direct_connect_gateway_attachment_output(transit_gateway_id=example_transit_gateway.id,
 *     dx_gateway_id=example_gateway.id)
 * example_vpn_connection = aws.ec2.VpnConnection("example",
 *     customer_gateway_id=example_customer_gateway.id,
 *     outside_ip_address_type="PrivateIpv4",
 *     transit_gateway_id=example_transit_gateway.id,
 *     transport_transit_gateway_attachment_id=example.id,
 *     type="ipsec.1",
 *     tags={
 *         "Name": "example_ipsec_vpn_example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleGateway = new Aws.DirectConnect.Gateway("example", new()
 *     {
 *         Name = "example_ipsec_vpn_example",
 *         AmazonSideAsn = "64512",
 *     });
 *     var exampleTransitGateway = new Aws.Ec2TransitGateway.TransitGateway("example", new()
 *     {
 *         AmazonSideAsn = 64513,
 *         Description = "example_ipsec_vpn_example",
 *         TransitGatewayCidrBlocks = new[]
 *         {
 *             "10.0.0.0/24",
 *         },
 *     });
 *     var exampleCustomerGateway = new Aws.Ec2.CustomerGateway("example", new()
 *     {
 *         BgpAsn = "64514",
 *         IpAddress = "10.0.0.1",
 *         Type = "ipsec.1",
 *         Tags =
 *         {
 *             { "Name", "example_ipsec_vpn_example" },
 *         },
 *     });
 *     var exampleGatewayAssociation = new Aws.DirectConnect.GatewayAssociation("example", new()
 *     {
 *         DxGatewayId = exampleGateway.Id,
 *         AssociatedGatewayId = exampleTransitGateway.Id,
 *         AllowedPrefixes = new[]
 *         {
 *             "10.0.0.0/8",
 *         },
 *     });
 *     var example = Aws.Ec2TransitGateway.GetDirectConnectGatewayAttachment.Invoke(new()
 *     {
 *         TransitGatewayId = exampleTransitGateway.Id,
 *         DxGatewayId = exampleGateway.Id,
 *     });
 *     var exampleVpnConnection = new Aws.Ec2.VpnConnection("example", new()
 *     {
 *         CustomerGatewayId = exampleCustomerGateway.Id,
 *         OutsideIpAddressType = "PrivateIpv4",
 *         TransitGatewayId = exampleTransitGateway.Id,
 *         TransportTransitGatewayAttachmentId = example.Apply(getDirectConnectGatewayAttachmentResult => getDirectConnectGatewayAttachmentResult.Id),
 *         Type = "ipsec.1",
 *         Tags =
 *         {
 *             { "Name", "example_ipsec_vpn_example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleGateway, err := directconnect.NewGateway(ctx, "example", &directconnect.GatewayArgs{
 * 			Name:          pulumi.String("example_ipsec_vpn_example"),
 * 			AmazonSideAsn: pulumi.String("64512"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitGateway, err := ec2transitgateway.NewTransitGateway(ctx, "example", &ec2transitgateway.TransitGatewayArgs{
 * 			AmazonSideAsn: pulumi.Int(64513),
 * 			Description:   pulumi.String("example_ipsec_vpn_example"),
 * 			TransitGatewayCidrBlocks: pulumi.StringArray{
 * 				pulumi.String("10.0.0.0/24"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleCustomerGateway, err := ec2.NewCustomerGateway(ctx, "example", &ec2.CustomerGatewayArgs{
 * 			BgpAsn:    pulumi.String("64514"),
 * 			IpAddress: pulumi.String("10.0.0.1"),
 * 			Type:      pulumi.String("ipsec.1"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example_ipsec_vpn_example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directconnect.NewGatewayAssociation(ctx, "example", &directconnect.GatewayAssociationArgs{
 * 			DxGatewayId:         exampleGateway.ID(),
 * 			AssociatedGatewayId: exampleTransitGateway.ID(),
 * 			AllowedPrefixes: pulumi.StringArray{
 * 				pulumi.String("10.0.0.0/8"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example := ec2transitgateway.GetDirectConnectGatewayAttachmentOutput(ctx, ec2transitgateway.GetDirectConnectGatewayAttachmentOutputArgs{
 * 			TransitGatewayId: exampleTransitGateway.ID(),
 * 			DxGatewayId:      exampleGateway.ID(),
 * 		}, nil)
 * 		_, err = ec2.NewVpnConnection(ctx, "example", &ec2.VpnConnectionArgs{
 * 			CustomerGatewayId:    exampleCustomerGateway.ID(),
 * 			OutsideIpAddressType: pulumi.String("PrivateIpv4"),
 * 			TransitGatewayId:     exampleTransitGateway.ID(),
 * 			TransportTransitGatewayAttachmentId: pulumi.String(example.ApplyT(func(example ec2transitgateway.GetDirectConnectGatewayAttachmentResult) (*string, error) {
 * 				return &example.Id, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			Type: pulumi.String("ipsec.1"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example_ipsec_vpn_example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.directconnect.GatewayAssociation;
 * import com.pulumi.aws.directconnect.GatewayAssociationArgs;
 * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
 * import com.pulumi.aws.ec2transitgateway.inputs.GetDirectConnectGatewayAttachmentArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .name("example_ipsec_vpn_example")
 *             .amazonSideAsn("64512")
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway", TransitGatewayArgs.builder()
 *             .amazonSideAsn("64513")
 *             .description("example_ipsec_vpn_example")
 *             .transitGatewayCidrBlocks("10.0.0.0/24")
 *             .build());
 *         var exampleCustomerGateway = new CustomerGateway("exampleCustomerGateway", CustomerGatewayArgs.builder()
 *             .bgpAsn(64514)
 *             .ipAddress("10.0.0.1")
 *             .type("ipsec.1")
 *             .tags(Map.of("Name", "example_ipsec_vpn_example"))
 *             .build());
 *         var exampleGatewayAssociation = new GatewayAssociation("exampleGatewayAssociation", GatewayAssociationArgs.builder()
 *             .dxGatewayId(exampleGateway.id())
 *             .associatedGatewayId(exampleTransitGateway.id())
 *             .allowedPrefixes("10.0.0.0/8")
 *             .build());
 *         final var example = Ec2transitgatewayFunctions.getDirectConnectGatewayAttachment(GetDirectConnectGatewayAttachmentArgs.builder()
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .dxGatewayId(exampleGateway.id())
 *             .build());
 *         var exampleVpnConnection = new VpnConnection("exampleVpnConnection", VpnConnectionArgs.builder()
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .outsideIpAddressType("PrivateIpv4")
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .transportTransitGatewayAttachmentId(example.applyValue(getDirectConnectGatewayAttachmentResult -> getDirectConnectGatewayAttachmentResult).applyValue(example -> example.applyValue(getDirectConnectGatewayAttachmentResult -> getDirectConnectGatewayAttachmentResult.id())))
 *             .type("ipsec.1")
 *             .tags(Map.of("Name", "example_ipsec_vpn_example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleGateway:
 *     type: aws:directconnect:Gateway
 *     name: example
 *     properties:
 *       name: example_ipsec_vpn_example
 *       amazonSideAsn: '64512'
 *   exampleTransitGateway:
 *     type: aws:ec2transitgateway:TransitGateway
 *     name: example
 *     properties:
 *       amazonSideAsn: '64513'
 *       description: example_ipsec_vpn_example
 *       transitGatewayCidrBlocks:
 *         - 10.0.0.0/24
 *   exampleCustomerGateway:
 *     type: aws:ec2:CustomerGateway
 *     name: example
 *     properties:
 *       bgpAsn: 64514
 *       ipAddress: 10.0.0.1
 *       type: ipsec.1
 *       tags:
 *         Name: example_ipsec_vpn_example
 *   exampleGatewayAssociation:
 *     type: aws:directconnect:GatewayAssociation
 *     name: example
 *     properties:
 *       dxGatewayId: ${exampleGateway.id}
 *       associatedGatewayId: ${exampleTransitGateway.id}
 *       allowedPrefixes:
 *         - 10.0.0.0/8
 *   exampleVpnConnection:
 *     type: aws:ec2:VpnConnection
 *     name: example
 *     properties:
 *       customerGatewayId: ${exampleCustomerGateway.id}
 *       outsideIpAddressType: PrivateIpv4
 *       transitGatewayId: ${exampleTransitGateway.id}
 *       transportTransitGatewayAttachmentId: ${example.id}
 *       type: ipsec.1
 *       tags:
 *         Name: example_ipsec_vpn_example
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ec2transitgateway:getDirectConnectGatewayAttachment
 *       Arguments:
 *         transitGatewayId: ${exampleTransitGateway.id}
 *         dxGatewayId: ${exampleGateway.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPN Connections using the VPN connection `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpnConnection:VpnConnection testvpnconnection vpn-40f41529
 * ```
 */
public class VpnConnection internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpnConnection,
) : KotlinCustomResource(javaResource, VpnConnectionMapper) {
    /**
     * Amazon Resource Name (ARN) of the VPN Connection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the core network.
     */
    public val coreNetworkArn: Output<String>
        get() = javaResource.coreNetworkArn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the core network attachment.
     */
    public val coreNetworkAttachmentArn: Output<String>
        get() = javaResource.coreNetworkAttachmentArn().applyValue({ args0 -> args0 })

    /**
     * The configuration information for the VPN connection's customer gateway (in the native XML format).
     */
    public val customerGatewayConfiguration: Output<String>
        get() = javaResource.customerGatewayConfiguration().applyValue({ args0 -> args0 })

    /**
     * The ID of the customer gateway.
     */
    public val customerGatewayId: Output<String>
        get() = javaResource.customerGatewayId().applyValue({ args0 -> args0 })

    /**
     * Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
     */
    public val enableAcceleration: Output<Boolean>
        get() = javaResource.enableAcceleration().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    public val localIpv4NetworkCidr: Output<String>
        get() = javaResource.localIpv4NetworkCidr().applyValue({ args0 -> args0 })

    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    public val localIpv6NetworkCidr: Output<String>
        get() = javaResource.localIpv6NetworkCidr().applyValue({ args0 -> args0 })

    /**
     * Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
     */
    public val outsideIpAddressType: Output<String>
        get() = javaResource.outsideIpAddressType().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR on the AWS side of the VPN connection.
     */
    public val remoteIpv4NetworkCidr: Output<String>
        get() = javaResource.remoteIpv4NetworkCidr().applyValue({ args0 -> args0 })

    /**
     * The IPv6 CIDR on the AWS side of the VPN connection.
     */
    public val remoteIpv6NetworkCidr: Output<String>
        get() = javaResource.remoteIpv6NetworkCidr().applyValue({ args0 -> args0 })

    /**
     * The static routes associated with the VPN connection. Detailed below.
     */
    public val routes: Output<List<VpnConnectionRoute>>
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vpnConnectionRouteToKotlin(args0)
                })
            })
        })

    /**
     * Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don't support BGP.
     */
    public val staticRoutesOnly: Output<Boolean>
        get() = javaResource.staticRoutesOnly().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `aws.ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
     */
    public val transitGatewayAttachmentId: Output<String>
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 -> args0 })

    /**
     * The ID of the EC2 Transit Gateway.
     */
    public val transitGatewayId: Output<String>?
        get() = javaResource.transitGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
     */
    public val transportTransitGatewayAttachmentId: Output<String>?
        get() = javaResource.transportTransitGatewayAttachmentId().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The public IP address of the first VPN tunnel.
     */
    public val tunnel1Address: Output<String>
        get() = javaResource.tunnel1Address().applyValue({ args0 -> args0 })

    /**
     * The bgp asn number of the first VPN tunnel.
     */
    public val tunnel1BgpAsn: Output<String>
        get() = javaResource.tunnel1BgpAsn().applyValue({ args0 -> args0 })

    /**
     * The bgp holdtime of the first VPN tunnel.
     */
    public val tunnel1BgpHoldtime: Output<Int>
        get() = javaResource.tunnel1BgpHoldtime().applyValue({ args0 -> args0 })

    /**
     * The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
     */
    public val tunnel1CgwInsideAddress: Output<String>
        get() = javaResource.tunnel1CgwInsideAddress().applyValue({ args0 -> args0 })

    /**
     * The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     */
    public val tunnel1DpdTimeoutAction: Output<String>?
        get() = javaResource.tunnel1DpdTimeoutAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
     */
    public val tunnel1DpdTimeoutSeconds: Output<Int>?
        get() = javaResource.tunnel1DpdTimeoutSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
     */
    public val tunnel1EnableTunnelLifecycleControl: Output<Boolean>?
        get() = javaResource.tunnel1EnableTunnelLifecycleControl().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
     */
    public val tunnel1IkeVersions: Output<List<String>>?
        get() = javaResource.tunnel1IkeVersions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     */
    public val tunnel1InsideCidr: Output<String>
        get() = javaResource.tunnel1InsideCidr().applyValue({ args0 -> args0 })

    /**
     * The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     */
    public val tunnel1InsideIpv6Cidr: Output<String>
        get() = javaResource.tunnel1InsideIpv6Cidr().applyValue({ args0 -> args0 })

    /**
     * Options for logging VPN tunnel activity. See Log Options below for more details.
     */
    public val tunnel1LogOptions: Output<VpnConnectionTunnel1LogOptions>
        get() = javaResource.tunnel1LogOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                vpnConnectionTunnel1LogOptionsToKotlin(args0)
            })
        })

    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     */
    public val tunnel1Phase1DhGroupNumbers: Output<List<Int>>?
        get() = javaResource.tunnel1Phase1DhGroupNumbers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     */
    public val tunnel1Phase1EncryptionAlgorithms: Output<List<String>>?
        get() = javaResource.tunnel1Phase1EncryptionAlgorithms().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     */
    public val tunnel1Phase1IntegrityAlgorithms: Output<List<String>>?
        get() = javaResource.tunnel1Phase1IntegrityAlgorithms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     */
    public val tunnel1Phase1LifetimeSeconds: Output<Int>?
        get() = javaResource.tunnel1Phase1LifetimeSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     */
    public val tunnel1Phase2DhGroupNumbers: Output<List<Int>>?
        get() = javaResource.tunnel1Phase2DhGroupNumbers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     */
    public val tunnel1Phase2EncryptionAlgorithms: Output<List<String>>?
        get() = javaResource.tunnel1Phase2EncryptionAlgorithms().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     */
    public val tunnel1Phase2IntegrityAlgorithms: Output<List<String>>?
        get() = javaResource.tunnel1Phase2IntegrityAlgorithms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     */
    public val tunnel1Phase2LifetimeSeconds: Output<Int>?
        get() = javaResource.tunnel1Phase2LifetimeSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     */
    public val tunnel1PresharedKey: Output<String>
        get() = javaResource.tunnel1PresharedKey().applyValue({ args0 -> args0 })

    /**
     * The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     */
    public val tunnel1RekeyFuzzPercentage: Output<Int>?
        get() = javaResource.tunnel1RekeyFuzzPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
     */
    public val tunnel1RekeyMarginTimeSeconds: Output<Int>?
        get() = javaResource.tunnel1RekeyMarginTimeSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
     */
    public val tunnel1ReplayWindowSize: Output<Int>?
        get() = javaResource.tunnel1ReplayWindowSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     */
    public val tunnel1StartupAction: Output<String>?
        get() = javaResource.tunnel1StartupAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
     */
    public val tunnel1VgwInsideAddress: Output<String>
        get() = javaResource.tunnel1VgwInsideAddress().applyValue({ args0 -> args0 })

    /**
     * The public IP address of the second VPN tunnel.
     */
    public val tunnel2Address: Output<String>
        get() = javaResource.tunnel2Address().applyValue({ args0 -> args0 })

    /**
     * The bgp asn number of the second VPN tunnel.
     */
    public val tunnel2BgpAsn: Output<String>
        get() = javaResource.tunnel2BgpAsn().applyValue({ args0 -> args0 })

    /**
     * The bgp holdtime of the second VPN tunnel.
     */
    public val tunnel2BgpHoldtime: Output<Int>
        get() = javaResource.tunnel2BgpHoldtime().applyValue({ args0 -> args0 })

    /**
     * The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
     */
    public val tunnel2CgwInsideAddress: Output<String>
        get() = javaResource.tunnel2CgwInsideAddress().applyValue({ args0 -> args0 })

    /**
     * The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     */
    public val tunnel2DpdTimeoutAction: Output<String>?
        get() = javaResource.tunnel2DpdTimeoutAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
     */
    public val tunnel2DpdTimeoutSeconds: Output<Int>?
        get() = javaResource.tunnel2DpdTimeoutSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
     */
    public val tunnel2EnableTunnelLifecycleControl: Output<Boolean>?
        get() = javaResource.tunnel2EnableTunnelLifecycleControl().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
     */
    public val tunnel2IkeVersions: Output<List<String>>?
        get() = javaResource.tunnel2IkeVersions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     */
    public val tunnel2InsideCidr: Output<String>
        get() = javaResource.tunnel2InsideCidr().applyValue({ args0 -> args0 })

    /**
     * The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     */
    public val tunnel2InsideIpv6Cidr: Output<String>
        get() = javaResource.tunnel2InsideIpv6Cidr().applyValue({ args0 -> args0 })

    /**
     * Options for logging VPN tunnel activity. See Log Options below for more details.
     */
    public val tunnel2LogOptions: Output<VpnConnectionTunnel2LogOptions>
        get() = javaResource.tunnel2LogOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                vpnConnectionTunnel2LogOptionsToKotlin(args0)
            })
        })

    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     */
    public val tunnel2Phase1DhGroupNumbers: Output<List<Int>>?
        get() = javaResource.tunnel2Phase1DhGroupNumbers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     */
    public val tunnel2Phase1EncryptionAlgorithms: Output<List<String>>?
        get() = javaResource.tunnel2Phase1EncryptionAlgorithms().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     */
    public val tunnel2Phase1IntegrityAlgorithms: Output<List<String>>?
        get() = javaResource.tunnel2Phase1IntegrityAlgorithms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     */
    public val tunnel2Phase1LifetimeSeconds: Output<Int>?
        get() = javaResource.tunnel2Phase1LifetimeSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     */
    public val tunnel2Phase2DhGroupNumbers: Output<List<Int>>?
        get() = javaResource.tunnel2Phase2DhGroupNumbers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     */
    public val tunnel2Phase2EncryptionAlgorithms: Output<List<String>>?
        get() = javaResource.tunnel2Phase2EncryptionAlgorithms().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     */
    public val tunnel2Phase2IntegrityAlgorithms: Output<List<String>>?
        get() = javaResource.tunnel2Phase2IntegrityAlgorithms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     */
    public val tunnel2Phase2LifetimeSeconds: Output<Int>?
        get() = javaResource.tunnel2Phase2LifetimeSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     */
    public val tunnel2PresharedKey: Output<String>
        get() = javaResource.tunnel2PresharedKey().applyValue({ args0 -> args0 })

    /**
     * The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     */
    public val tunnel2RekeyFuzzPercentage: Output<Int>?
        get() = javaResource.tunnel2RekeyFuzzPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
     */
    public val tunnel2RekeyMarginTimeSeconds: Output<Int>?
        get() = javaResource.tunnel2RekeyMarginTimeSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
     */
    public val tunnel2ReplayWindowSize: Output<Int>?
        get() = javaResource.tunnel2ReplayWindowSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     */
    public val tunnel2StartupAction: Output<String>?
        get() = javaResource.tunnel2StartupAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
     */
    public val tunnel2VgwInsideAddress: Output<String>
        get() = javaResource.tunnel2VgwInsideAddress().applyValue({ args0 -> args0 })

    /**
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
     */
    public val tunnelInsideIpVersion: Output<String>
        get() = javaResource.tunnelInsideIpVersion().applyValue({ args0 -> args0 })

    /**
     * The type of VPN connection. The only type AWS supports at this time is "ipsec.1".
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Telemetry for the VPN tunnels. Detailed below.
     */
    public val vgwTelemetries: Output<List<VpnConnectionVgwTelemetry>>
        get() = javaResource.vgwTelemetries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> vpnConnectionVgwTelemetryToKotlin(args0) })
            })
        })

    /**
     * The ID of the Virtual Private Gateway.
     */
    public val vpnGatewayId: Output<String>?
        get() = javaResource.vpnGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VpnConnectionMapper : ResourceMapper<VpnConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpnConnection::class == javaResource::class

    override fun map(javaResource: Resource): VpnConnection = VpnConnection(
        javaResource as
            com.pulumi.aws.ec2.VpnConnection,
    )
}

/**
 * @see [VpnConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnConnection].
 */
public suspend fun vpnConnection(
    name: String,
    block: suspend VpnConnectionResourceBuilder.() -> Unit,
): VpnConnection {
    val builder = VpnConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnConnection(name: String): VpnConnection {
    val builder = VpnConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
