@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VpnGateway].
 */
@PulumiTagMarker
public class VpnGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnGatewayArgs = VpnGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnGatewayArgsBuilder.() -> Unit) {
        val builder = VpnGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpnGateway {
        val builtJavaResource = com.pulumi.aws.ec2.VpnGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpnGateway(builtJavaResource)
    }
}

/**
 * Provides a resource to create a VPC VPN Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const vpnGw = new aws.ec2.VpnGateway("vpn_gw", {
 *     vpcId: main.id,
 *     tags: {
 *         Name: "main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * vpn_gw = aws.ec2.VpnGateway("vpn_gw",
 *     vpc_id=main["id"],
 *     tags={
 *         "Name": "main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnGw = new Aws.Ec2.VpnGateway("vpn_gw", new()
 *     {
 *         VpcId = main.Id,
 *         Tags =
 *         {
 *             { "Name", "main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpnGateway(ctx, "vpn_gw", &ec2.VpnGatewayArgs{
 * 			VpcId: pulumi.Any(main.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnGw = new VpnGateway("vpnGw", VpnGatewayArgs.builder()
 *             .vpcId(main.id())
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpnGw:
 *     type: aws:ec2:VpnGateway
 *     name: vpn_gw
 *     properties:
 *       vpcId: ${main.id}
 *       tags:
 *         Name: main
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPN Gateways using the VPN gateway `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpnGateway:VpnGateway testvpngateway vgw-9a4cacf3
 * ```
 */
public class VpnGateway internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpnGateway,
) : KotlinCustomResource(javaResource, VpnGatewayMapper) {
    /**
     * The Autonomous System Number (ASN) for the Amazon side of the gateway. If you don't specify an ASN, the virtual private gateway is created with the default ASN.
     */
    public val amazonSideAsn: Output<String>
        get() = javaResource.amazonSideAsn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the VPN Gateway.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone for the virtual private gateway.
     */
    public val availabilityZone: Output<String>?
        get() = javaResource.availabilityZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC ID to create in.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object VpnGatewayMapper : ResourceMapper<VpnGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpnGateway::class == javaResource::class

    override fun map(javaResource: Resource): VpnGateway = VpnGateway(
        javaResource as
            com.pulumi.aws.ec2.VpnGateway,
    )
}

/**
 * @see [VpnGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnGateway].
 */
public suspend fun vpnGateway(name: String, block: suspend VpnGatewayResourceBuilder.() -> Unit): VpnGateway {
    val builder = VpnGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnGateway(name: String): VpnGateway {
    val builder = VpnGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
