@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpnGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a VPC VPN Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const vpnGw = new aws.ec2.VpnGateway("vpn_gw", {
 *     vpcId: main.id,
 *     tags: {
 *         Name: "main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * vpn_gw = aws.ec2.VpnGateway("vpn_gw",
 *     vpc_id=main["id"],
 *     tags={
 *         "Name": "main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnGw = new Aws.Ec2.VpnGateway("vpn_gw", new()
 *     {
 *         VpcId = main.Id,
 *         Tags =
 *         {
 *             { "Name", "main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpnGateway(ctx, "vpn_gw", &ec2.VpnGatewayArgs{
 * 			VpcId: pulumi.Any(main.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnGw = new VpnGateway("vpnGw", VpnGatewayArgs.builder()
 *             .vpcId(main.id())
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpnGw:
 *     type: aws:ec2:VpnGateway
 *     name: vpn_gw
 *     properties:
 *       vpcId: ${main.id}
 *       tags:
 *         Name: main
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPN Gateways using the VPN gateway `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpnGateway:VpnGateway testvpngateway vgw-9a4cacf3
 * ```
 * @property amazonSideAsn The Autonomous System Number (ASN) for the Amazon side of the gateway. If you don't specify an ASN, the virtual private gateway is created with the default ASN.
 * @property availabilityZone The Availability Zone for the virtual private gateway.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId The VPC ID to create in.
 */
public data class VpnGatewayArgs(
    public val amazonSideAsn: Output<String>? = null,
    public val availabilityZone: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpnGatewayArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpnGatewayArgs =
        com.pulumi.aws.ec2.VpnGatewayArgs.builder()
            .amazonSideAsn(amazonSideAsn?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnGatewayArgs].
 */
@PulumiTagMarker
public class VpnGatewayArgsBuilder internal constructor() {
    private var amazonSideAsn: Output<String>? = null

    private var availabilityZone: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The Autonomous System Number (ASN) for the Amazon side of the gateway. If you don't specify an ASN, the virtual private gateway is created with the default ASN.
     */
    @JvmName("uylngrfofocebpsq")
    public suspend fun amazonSideAsn(`value`: Output<String>) {
        this.amazonSideAsn = value
    }

    /**
     * @param value The Availability Zone for the virtual private gateway.
     */
    @JvmName("fdthiphvuxuwbdde")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oyaktaxvieclkrth")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC ID to create in.
     */
    @JvmName("tqfmfpuxcbuywxbo")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The Autonomous System Number (ASN) for the Amazon side of the gateway. If you don't specify an ASN, the virtual private gateway is created with the default ASN.
     */
    @JvmName("tubtijsdcsorkaju")
    public suspend fun amazonSideAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonSideAsn = mapped
    }

    /**
     * @param value The Availability Zone for the virtual private gateway.
     */
    @JvmName("avclbyxxqpyxipij")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cnppbcioxvykkhpa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cefqjfepjiuvrxcu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC ID to create in.
     */
    @JvmName("mqkjfvuocxrxqrxv")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpnGatewayArgs = VpnGatewayArgs(
        amazonSideAsn = amazonSideAsn,
        availabilityZone = availabilityZone,
        tags = tags,
        vpcId = vpcId,
    )
}
