@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpnGatewayRoutePropagation].
 */
@PulumiTagMarker
public class VpnGatewayRoutePropagationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnGatewayRoutePropagationArgs = VpnGatewayRoutePropagationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnGatewayRoutePropagationArgsBuilder.() -> Unit) {
        val builder = VpnGatewayRoutePropagationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpnGatewayRoutePropagation {
        val builtJavaResource = com.pulumi.aws.ec2.VpnGatewayRoutePropagation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpnGatewayRoutePropagation(builtJavaResource)
    }
}

/**
 * Requests automatic route propagation between a VPN gateway and a route table.
 * > **Note:** This resource should not be used with a route table that has
 * the `propagating_vgws` argument set. If that argument is set, any route
 * propagation not explicitly listed in its value will be removed.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.VpnGatewayRoutePropagation("example", {
 *     vpnGatewayId: exampleAwsVpnGateway.id,
 *     routeTableId: exampleAwsRouteTable.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.VpnGatewayRoutePropagation("example",
 *     vpn_gateway_id=example_aws_vpn_gateway["id"],
 *     route_table_id=example_aws_route_table["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.VpnGatewayRoutePropagation("example", new()
 *     {
 *         VpnGatewayId = exampleAwsVpnGateway.Id,
 *         RouteTableId = exampleAwsRouteTable.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpnGatewayRoutePropagation(ctx, "example", &ec2.VpnGatewayRoutePropagationArgs{
 * 			VpnGatewayId: pulumi.Any(exampleAwsVpnGateway.Id),
 * 			RouteTableId: pulumi.Any(exampleAwsRouteTable.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpnGatewayRoutePropagation;
 * import com.pulumi.aws.ec2.VpnGatewayRoutePropagationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpnGatewayRoutePropagation("example", VpnGatewayRoutePropagationArgs.builder()
 *             .vpnGatewayId(exampleAwsVpnGateway.id())
 *             .routeTableId(exampleAwsRouteTable.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpnGatewayRoutePropagation
 *     properties:
 *       vpnGatewayId: ${exampleAwsVpnGateway.id}
 *       routeTableId: ${exampleAwsRouteTable.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class VpnGatewayRoutePropagation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpnGatewayRoutePropagation,
) : KotlinCustomResource(javaResource, VpnGatewayRoutePropagationMapper) {
    /**
     * The id of the `aws.ec2.RouteTable` to propagate routes into.
     */
    public val routeTableId: Output<String>
        get() = javaResource.routeTableId().applyValue({ args0 -> args0 })

    /**
     * The id of the `aws.ec2.VpnGateway` to propagate routes from.
     */
    public val vpnGatewayId: Output<String>
        get() = javaResource.vpnGatewayId().applyValue({ args0 -> args0 })
}

public object VpnGatewayRoutePropagationMapper : ResourceMapper<VpnGatewayRoutePropagation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpnGatewayRoutePropagation::class == javaResource::class

    override fun map(javaResource: Resource): VpnGatewayRoutePropagation =
        VpnGatewayRoutePropagation(javaResource as com.pulumi.aws.ec2.VpnGatewayRoutePropagation)
}

/**
 * @see [VpnGatewayRoutePropagation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnGatewayRoutePropagation].
 */
public suspend fun vpnGatewayRoutePropagation(
    name: String,
    block: suspend VpnGatewayRoutePropagationResourceBuilder.() -> Unit,
): VpnGatewayRoutePropagation {
    val builder = VpnGatewayRoutePropagationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnGatewayRoutePropagation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnGatewayRoutePropagation(name: String): VpnGatewayRoutePropagation {
    val builder = VpnGatewayRoutePropagationResourceBuilder()
    builder.name(name)
    return builder.build()
}
