@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpnGatewayRoutePropagationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Requests automatic route propagation between a VPN gateway and a route table.
 * > **Note:** This resource should not be used with a route table that has
 * the `propagating_vgws` argument set. If that argument is set, any route
 * propagation not explicitly listed in its value will be removed.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.VpnGatewayRoutePropagation("example", {
 *     vpnGatewayId: exampleAwsVpnGateway.id,
 *     routeTableId: exampleAwsRouteTable.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.VpnGatewayRoutePropagation("example",
 *     vpn_gateway_id=example_aws_vpn_gateway["id"],
 *     route_table_id=example_aws_route_table["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.VpnGatewayRoutePropagation("example", new()
 *     {
 *         VpnGatewayId = exampleAwsVpnGateway.Id,
 *         RouteTableId = exampleAwsRouteTable.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpnGatewayRoutePropagation(ctx, "example", &ec2.VpnGatewayRoutePropagationArgs{
 * 			VpnGatewayId: pulumi.Any(exampleAwsVpnGateway.Id),
 * 			RouteTableId: pulumi.Any(exampleAwsRouteTable.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpnGatewayRoutePropagation;
 * import com.pulumi.aws.ec2.VpnGatewayRoutePropagationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpnGatewayRoutePropagation("example", VpnGatewayRoutePropagationArgs.builder()
 *             .vpnGatewayId(exampleAwsVpnGateway.id())
 *             .routeTableId(exampleAwsRouteTable.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpnGatewayRoutePropagation
 *     properties:
 *       vpnGatewayId: ${exampleAwsVpnGateway.id}
 *       routeTableId: ${exampleAwsRouteTable.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property routeTableId The id of the `aws.ec2.RouteTable` to propagate routes into.
 * @property vpnGatewayId The id of the `aws.ec2.VpnGateway` to propagate routes from.
 */
public data class VpnGatewayRoutePropagationArgs(
    public val routeTableId: Output<String>? = null,
    public val vpnGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpnGatewayRoutePropagationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpnGatewayRoutePropagationArgs =
        com.pulumi.aws.ec2.VpnGatewayRoutePropagationArgs.builder()
            .routeTableId(routeTableId?.applyValue({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnGatewayRoutePropagationArgs].
 */
@PulumiTagMarker
public class VpnGatewayRoutePropagationArgsBuilder internal constructor() {
    private var routeTableId: Output<String>? = null

    private var vpnGatewayId: Output<String>? = null

    /**
     * @param value The id of the `aws.ec2.RouteTable` to propagate routes into.
     */
    @JvmName("lrygivgmwvcgcfbr")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value The id of the `aws.ec2.VpnGateway` to propagate routes from.
     */
    @JvmName("trwjgofcovdfyrcb")
    public suspend fun vpnGatewayId(`value`: Output<String>) {
        this.vpnGatewayId = value
    }

    /**
     * @param value The id of the `aws.ec2.RouteTable` to propagate routes into.
     */
    @JvmName("pqnbegnprrabwkry")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    /**
     * @param value The id of the `aws.ec2.VpnGateway` to propagate routes from.
     */
    @JvmName("afpjaormylfaywqn")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayId = mapped
    }

    internal fun build(): VpnGatewayRoutePropagationArgs = VpnGatewayRoutePropagationArgs(
        routeTableId = routeTableId,
        vpnGatewayId = vpnGatewayId,
    )
}
