@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The strategy of the placement group determines how the instances are organized within the group.
 * See https://docs.aws.amazon.com/cli/latest/reference/ec2/create-placement-group.html
 */
public enum class PlacementStrategy(
    public val javaValue: com.pulumi.aws.ec2.enums.PlacementStrategy,
) : ConvertibleToJava<com.pulumi.aws.ec2.enums.PlacementStrategy> {
    /**
     * A `spread` placement group places instances on distinct hardware.
     */
    Spread(com.pulumi.aws.ec2.enums.PlacementStrategy.Spread),

    /**
     * A `cluster` placement group is a logical grouping of instances within a single
     * Availability Zone that benefit from low network latency, high network throughput.
     */
    Cluster(com.pulumi.aws.ec2.enums.PlacementStrategy.Cluster),
    ;

    override fun toJava(): com.pulumi.aws.ec2.enums.PlacementStrategy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.enums.PlacementStrategy): PlacementStrategy =
            PlacementStrategy.values().first { it.javaValue == javaType }
    }
}
