@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.DefaultRouteTableRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlock The CIDR block of the route.
 * @property coreNetworkArn The Amazon Resource Name (ARN) of a core network.
 * @property destinationPrefixListId The ID of a managed prefix list destination of the route.
 * One of the following target arguments must be supplied:
 * @property egressOnlyGatewayId Identifier of a VPC Egress Only Internet Gateway.
 * @property gatewayId Identifier of a VPC internet gateway or a virtual private gateway.
 * @property instanceId Identifier of an EC2 instance.
 * @property ipv6CidrBlock The Ipv6 CIDR block of the route
 * @property natGatewayId Identifier of a VPC NAT gateway.
 * @property networkInterfaceId Identifier of an EC2 network interface.
 * @property transitGatewayId Identifier of an EC2 Transit Gateway.
 * @property vpcEndpointId Identifier of a VPC Endpoint. This route must be removed prior to VPC Endpoint deletion.
 * @property vpcPeeringConnectionId Identifier of a VPC peering connection.
 * Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
 */
public data class DefaultRouteTableRouteArgs(
    public val cidrBlock: Output<String>? = null,
    public val coreNetworkArn: Output<String>? = null,
    public val destinationPrefixListId: Output<String>? = null,
    public val egressOnlyGatewayId: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val natGatewayId: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val transitGatewayId: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
    public val vpcPeeringConnectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.DefaultRouteTableRouteArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.DefaultRouteTableRouteArgs =
        com.pulumi.aws.ec2.inputs.DefaultRouteTableRouteArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .coreNetworkArn(coreNetworkArn?.applyValue({ args0 -> args0 }))
            .destinationPrefixListId(destinationPrefixListId?.applyValue({ args0 -> args0 }))
            .egressOnlyGatewayId(egressOnlyGatewayId?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
            .natGatewayId(natGatewayId?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 }))
            .vpcPeeringConnectionId(vpcPeeringConnectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultRouteTableRouteArgs].
 */
@PulumiTagMarker
public class DefaultRouteTableRouteArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var coreNetworkArn: Output<String>? = null

    private var destinationPrefixListId: Output<String>? = null

    private var egressOnlyGatewayId: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var natGatewayId: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var transitGatewayId: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    private var vpcPeeringConnectionId: Output<String>? = null

    /**
     * @param value The CIDR block of the route.
     */
    @JvmName("iwkfsjetioyplquw")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a core network.
     */
    @JvmName("llnahwnwjssexgey")
    public suspend fun coreNetworkArn(`value`: Output<String>) {
        this.coreNetworkArn = value
    }

    /**
     * @param value The ID of a managed prefix list destination of the route.
     * One of the following target arguments must be supplied:
     */
    @JvmName("mchisibdyxtwahfh")
    public suspend fun destinationPrefixListId(`value`: Output<String>) {
        this.destinationPrefixListId = value
    }

    /**
     * @param value Identifier of a VPC Egress Only Internet Gateway.
     */
    @JvmName("lgkvsbrgbtpamewg")
    public suspend fun egressOnlyGatewayId(`value`: Output<String>) {
        this.egressOnlyGatewayId = value
    }

    /**
     * @param value Identifier of a VPC internet gateway or a virtual private gateway.
     */
    @JvmName("cnlbusffvqslbxns")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value Identifier of an EC2 instance.
     */
    @JvmName("harhjwflejfuecnm")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The Ipv6 CIDR block of the route
     */
    @JvmName("vveapjedscbaffow")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value Identifier of a VPC NAT gateway.
     */
    @JvmName("judoplmndyseklci")
    public suspend fun natGatewayId(`value`: Output<String>) {
        this.natGatewayId = value
    }

    /**
     * @param value Identifier of an EC2 network interface.
     */
    @JvmName("nlburwscxxgmfcjx")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value Identifier of an EC2 Transit Gateway.
     */
    @JvmName("jkfybofplxrtunmu")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value Identifier of a VPC Endpoint. This route must be removed prior to VPC Endpoint deletion.
     */
    @JvmName("ibdnoefnoncninks")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value Identifier of a VPC peering connection.
     * Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
     */
    @JvmName("dpoiflpdshvwnmxe")
    public suspend fun vpcPeeringConnectionId(`value`: Output<String>) {
        this.vpcPeeringConnectionId = value
    }

    /**
     * @param value The CIDR block of the route.
     */
    @JvmName("siiegikohrbtfikg")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a core network.
     */
    @JvmName("fabcojskqffucdab")
    public suspend fun coreNetworkArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkArn = mapped
    }

    /**
     * @param value The ID of a managed prefix list destination of the route.
     * One of the following target arguments must be supplied:
     */
    @JvmName("vxpcuykvnuwhpdbi")
    public suspend fun destinationPrefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPrefixListId = mapped
    }

    /**
     * @param value Identifier of a VPC Egress Only Internet Gateway.
     */
    @JvmName("rurmplftdhikwwxj")
    public suspend fun egressOnlyGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressOnlyGatewayId = mapped
    }

    /**
     * @param value Identifier of a VPC internet gateway or a virtual private gateway.
     */
    @JvmName("oalhpljrpnawwodw")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value Identifier of an EC2 instance.
     */
    @JvmName("bosfxffysjmqubfg")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The Ipv6 CIDR block of the route
     */
    @JvmName("uylxqydhfcmdsauv")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value Identifier of a VPC NAT gateway.
     */
    @JvmName("tfstwvvlqudhappd")
    public suspend fun natGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayId = mapped
    }

    /**
     * @param value Identifier of an EC2 network interface.
     */
    @JvmName("edluuthrljubkknu")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value Identifier of an EC2 Transit Gateway.
     */
    @JvmName("kqdyokuvuybctsmt")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    /**
     * @param value Identifier of a VPC Endpoint. This route must be removed prior to VPC Endpoint deletion.
     */
    @JvmName("aqrrfilwuvbddlsi")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    /**
     * @param value Identifier of a VPC peering connection.
     * Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
     */
    @JvmName("qoticubekmjstapi")
    public suspend fun vpcPeeringConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcPeeringConnectionId = mapped
    }

    internal fun build(): DefaultRouteTableRouteArgs = DefaultRouteTableRouteArgs(
        cidrBlock = cidrBlock,
        coreNetworkArn = coreNetworkArn,
        destinationPrefixListId = destinationPrefixListId,
        egressOnlyGatewayId = egressOnlyGatewayId,
        gatewayId = gatewayId,
        instanceId = instanceId,
        ipv6CidrBlock = ipv6CidrBlock,
        natGatewayId = natGatewayId,
        networkInterfaceId = networkInterfaceId,
        transitGatewayId = transitGatewayId,
        vpcEndpointId = vpcEndpointId,
        vpcPeeringConnectionId = vpcPeeringConnectionId,
    )
}
