@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max The maximum amount of memory, in MiB. To specify no maximum limit, omit this parameter.
 * @property min The minimum amount of memory, in MiB. To specify no minimum limit, specify `0`.
 */
public data class FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs].
 */
@PulumiTagMarker
public class FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgsBuilder internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value The maximum amount of memory, in MiB. To specify no maximum limit, omit this parameter.
     */
    @JvmName("eoapmmxlsnuxtgtk")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value The minimum amount of memory, in MiB. To specify no minimum limit, specify `0`.
     */
    @JvmName("koviospwvqttjqql")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value The maximum amount of memory, in MiB. To specify no maximum limit, omit this parameter.
     */
    @JvmName("airmamplywwgbsds")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value The minimum amount of memory, in MiB. To specify no minimum limit, specify `0`.
     */
    @JvmName("ljohlwtbhxqrprux")
    public suspend fun min(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs =
        FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs(
            max = max,
            min = min ?: throw PulumiNullFieldException("min"),
        )
}
