@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max The maximum amount of network bandwidth, in Gbps. To specify no maximum limit, omit this parameter.
 * @property min The minimum amount of network bandwidth, in Gbps. To specify no minimum limit, omit this parameter.
 */
public data class FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs(
    public val max: Output<Double>? = null,
    public val min: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs].
 */
@PulumiTagMarker
public class FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder
internal constructor() {
    private var max: Output<Double>? = null

    private var min: Output<Double>? = null

    /**
     * @param value The maximum amount of network bandwidth, in Gbps. To specify no maximum limit, omit this parameter.
     */
    @JvmName("bredqjepjddvahpy")
    public suspend fun max(`value`: Output<Double>) {
        this.max = value
    }

    /**
     * @param value The minimum amount of network bandwidth, in Gbps. To specify no minimum limit, omit this parameter.
     */
    @JvmName("qkxrhiyeusxlyhvq")
    public suspend fun min(`value`: Output<Double>) {
        this.min = value
    }

    /**
     * @param value The maximum amount of network bandwidth, in Gbps. To specify no maximum limit, omit this parameter.
     */
    @JvmName("akyoyvtrdfhmyjqh")
    public suspend fun max(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value The minimum amount of network bandwidth, in Gbps. To specify no minimum limit, omit this parameter.
     */
    @JvmName("jbibryruidugsdxe")
    public suspend fun min(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs =
        FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs(
            max = max,
            min = min,
        )
}
