@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
 * @property min The minimum number of vCPUs. To specify no minimum limit, specify `0`.
 */
public data class FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs].
 */
@PulumiTagMarker
public class FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgsBuilder internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
     */
    @JvmName("ddeducjehpcwheey")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value The minimum number of vCPUs. To specify no minimum limit, specify `0`.
     */
    @JvmName("otqlxyvyvjprsewj")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
     */
    @JvmName("jjqqiwqkwbgsyydp")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value The minimum number of vCPUs. To specify no minimum limit, specify `0`.
     */
    @JvmName("kfpvhtqaijhyrtex")
    public suspend fun min(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs =
        FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs(
            max = max,
            min = min ?: throw PulumiNullFieldException("min"),
        )
}
