@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allocationStrategy The order of the launch template overrides to use in fulfilling On-Demand capacity. Valid values: `lowestPrice`, `prioritized`. Default: `lowestPrice`.
 * @property capacityReservationOptions The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity. Supported only for fleets of type `instant`.
 * @property maxTotalPrice The maximum amount per hour for On-Demand Instances that you're willing to pay.
 * @property minTargetCapacity The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances. Supported only for fleets of type `instant`.
 * If you specify `min_target_capacity`, at least one of the following must be specified: `single_availability_zone` or `single_instance_type`.
 * @property singleAvailabilityZone Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type `instant`.
 * @property singleInstanceType Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type `instant`.
 */
public data class FleetOnDemandOptionsArgs(
    public val allocationStrategy: Output<String>? = null,
    public val capacityReservationOptions: Output<FleetOnDemandOptionsCapacityReservationOptionsArgs>? =
        null,
    public val maxTotalPrice: Output<String>? = null,
    public val minTargetCapacity: Output<Int>? = null,
    public val singleAvailabilityZone: Output<Boolean>? = null,
    public val singleInstanceType: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsArgs =
        com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsArgs.builder()
            .allocationStrategy(allocationStrategy?.applyValue({ args0 -> args0 }))
            .capacityReservationOptions(
                capacityReservationOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maxTotalPrice(maxTotalPrice?.applyValue({ args0 -> args0 }))
            .minTargetCapacity(minTargetCapacity?.applyValue({ args0 -> args0 }))
            .singleAvailabilityZone(singleAvailabilityZone?.applyValue({ args0 -> args0 }))
            .singleInstanceType(singleInstanceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetOnDemandOptionsArgs].
 */
@PulumiTagMarker
public class FleetOnDemandOptionsArgsBuilder internal constructor() {
    private var allocationStrategy: Output<String>? = null

    private var capacityReservationOptions:
        Output<FleetOnDemandOptionsCapacityReservationOptionsArgs>? = null

    private var maxTotalPrice: Output<String>? = null

    private var minTargetCapacity: Output<Int>? = null

    private var singleAvailabilityZone: Output<Boolean>? = null

    private var singleInstanceType: Output<Boolean>? = null

    /**
     * @param value The order of the launch template overrides to use in fulfilling On-Demand capacity. Valid values: `lowestPrice`, `prioritized`. Default: `lowestPrice`.
     */
    @JvmName("kcfiadbuhbaqjbfx")
    public suspend fun allocationStrategy(`value`: Output<String>) {
        this.allocationStrategy = value
    }

    /**
     * @param value The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity. Supported only for fleets of type `instant`.
     */
    @JvmName("artovtoncqtaiiof")
    public suspend fun capacityReservationOptions(`value`: Output<FleetOnDemandOptionsCapacityReservationOptionsArgs>) {
        this.capacityReservationOptions = value
    }

    /**
     * @param value The maximum amount per hour for On-Demand Instances that you're willing to pay.
     */
    @JvmName("wnwnjixkjhexnlhd")
    public suspend fun maxTotalPrice(`value`: Output<String>) {
        this.maxTotalPrice = value
    }

    /**
     * @param value The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances. Supported only for fleets of type `instant`.
     * If you specify `min_target_capacity`, at least one of the following must be specified: `single_availability_zone` or `single_instance_type`.
     */
    @JvmName("ggvsplorthkjdwxv")
    public suspend fun minTargetCapacity(`value`: Output<Int>) {
        this.minTargetCapacity = value
    }

    /**
     * @param value Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type `instant`.
     */
    @JvmName("siwkfphtohdsjmxj")
    public suspend fun singleAvailabilityZone(`value`: Output<Boolean>) {
        this.singleAvailabilityZone = value
    }

    /**
     * @param value Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type `instant`.
     */
    @JvmName("hrrvqovtnyfxbslo")
    public suspend fun singleInstanceType(`value`: Output<Boolean>) {
        this.singleInstanceType = value
    }

    /**
     * @param value The order of the launch template overrides to use in fulfilling On-Demand capacity. Valid values: `lowestPrice`, `prioritized`. Default: `lowestPrice`.
     */
    @JvmName("vwuvfjjyqjwowfqv")
    public suspend fun allocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity. Supported only for fleets of type `instant`.
     */
    @JvmName("vlfeeujsmqyfegpy")
    public suspend fun capacityReservationOptions(`value`: FleetOnDemandOptionsCapacityReservationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationOptions = mapped
    }

    /**
     * @param argument The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity. Supported only for fleets of type `instant`.
     */
    @JvmName("yhoivqiksocsjgdu")
    public suspend fun capacityReservationOptions(argument: suspend FleetOnDemandOptionsCapacityReservationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = FleetOnDemandOptionsCapacityReservationOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationOptions = mapped
    }

    /**
     * @param value The maximum amount per hour for On-Demand Instances that you're willing to pay.
     */
    @JvmName("erhfuqttnwppaawb")
    public suspend fun maxTotalPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTotalPrice = mapped
    }

    /**
     * @param value The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances. Supported only for fleets of type `instant`.
     * If you specify `min_target_capacity`, at least one of the following must be specified: `single_availability_zone` or `single_instance_type`.
     */
    @JvmName("bppwneebroavwlut")
    public suspend fun minTargetCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTargetCapacity = mapped
    }

    /**
     * @param value Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type `instant`.
     */
    @JvmName("owhmsjlexrvvbfvx")
    public suspend fun singleAvailabilityZone(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleAvailabilityZone = mapped
    }

    /**
     * @param value Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type `instant`.
     */
    @JvmName("qplulbgegscuorkh")
    public suspend fun singleInstanceType(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleInstanceType = mapped
    }

    internal fun build(): FleetOnDemandOptionsArgs = FleetOnDemandOptionsArgs(
        allocationStrategy = allocationStrategy,
        capacityReservationOptions = capacityReservationOptions,
        maxTotalPrice = maxTotalPrice,
        minTargetCapacity = minTargetCapacity,
        singleAvailabilityZone = singleAvailabilityZone,
        singleInstanceType = singleInstanceType,
    )
}
