@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsCapacityReservationOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property usageStrategy Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity. Valid values: `use-capacity-reservations-first`.
 */
public data class FleetOnDemandOptionsCapacityReservationOptionsArgs(
    public val usageStrategy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsCapacityReservationOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsCapacityReservationOptionsArgs =
        com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsCapacityReservationOptionsArgs.builder()
            .usageStrategy(usageStrategy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetOnDemandOptionsCapacityReservationOptionsArgs].
 */
@PulumiTagMarker
public class FleetOnDemandOptionsCapacityReservationOptionsArgsBuilder internal constructor() {
    private var usageStrategy: Output<String>? = null

    /**
     * @param value Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity. Valid values: `use-capacity-reservations-first`.
     */
    @JvmName("hrhowcflisfyuift")
    public suspend fun usageStrategy(`value`: Output<String>) {
        this.usageStrategy = value
    }

    /**
     * @param value Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity. Valid values: `use-capacity-reservations-first`.
     */
    @JvmName("voeytupatrjhouhi")
    public suspend fun usageStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageStrategy = mapped
    }

    internal fun build(): FleetOnDemandOptionsCapacityReservationOptionsArgs =
        FleetOnDemandOptionsCapacityReservationOptionsArgs(
            usageStrategy = usageStrategy,
        )
}
