@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetSpotOptionsMaintenanceStrategiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property capacityRebalance Nested argument containing the capacity rebalance for your fleet request. Defined below.
 */
public data class FleetSpotOptionsMaintenanceStrategiesArgs(
    public val capacityRebalance: Output<FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetSpotOptionsMaintenanceStrategiesArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetSpotOptionsMaintenanceStrategiesArgs =
        com.pulumi.aws.ec2.inputs.FleetSpotOptionsMaintenanceStrategiesArgs.builder()
            .capacityRebalance(
                capacityRebalance?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FleetSpotOptionsMaintenanceStrategiesArgs].
 */
@PulumiTagMarker
public class FleetSpotOptionsMaintenanceStrategiesArgsBuilder internal constructor() {
    private var capacityRebalance: Output<FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs>? =
        null

    /**
     * @param value Nested argument containing the capacity rebalance for your fleet request. Defined below.
     */
    @JvmName("wwiksulfwhensrwt")
    public suspend fun capacityRebalance(`value`: Output<FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs>) {
        this.capacityRebalance = value
    }

    /**
     * @param value Nested argument containing the capacity rebalance for your fleet request. Defined below.
     */
    @JvmName("hqokgmysetbkbesv")
    public suspend fun capacityRebalance(`value`: FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityRebalance = mapped
    }

    /**
     * @param argument Nested argument containing the capacity rebalance for your fleet request. Defined below.
     */
    @JvmName("ixhtwmhoqijtubkc")
    public suspend fun capacityRebalance(argument: suspend FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.capacityRebalance = mapped
    }

    internal fun build(): FleetSpotOptionsMaintenanceStrategiesArgs =
        FleetSpotOptionsMaintenanceStrategiesArgs(
            capacityRebalance = capacityRebalance,
        )
}
