@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FlowLogDestinationOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fileFormat The format for the flow log. Default value: `plain-text`. Valid values: `plain-text`, `parquet`.
 * @property hiveCompatiblePartitions Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. Default value: `false`.
 * @property perHourPartition Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries. Default value: `false`.
 */
public data class FlowLogDestinationOptionsArgs(
    public val fileFormat: Output<String>? = null,
    public val hiveCompatiblePartitions: Output<Boolean>? = null,
    public val perHourPartition: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FlowLogDestinationOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FlowLogDestinationOptionsArgs =
        com.pulumi.aws.ec2.inputs.FlowLogDestinationOptionsArgs.builder()
            .fileFormat(fileFormat?.applyValue({ args0 -> args0 }))
            .hiveCompatiblePartitions(hiveCompatiblePartitions?.applyValue({ args0 -> args0 }))
            .perHourPartition(perHourPartition?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowLogDestinationOptionsArgs].
 */
@PulumiTagMarker
public class FlowLogDestinationOptionsArgsBuilder internal constructor() {
    private var fileFormat: Output<String>? = null

    private var hiveCompatiblePartitions: Output<Boolean>? = null

    private var perHourPartition: Output<Boolean>? = null

    /**
     * @param value The format for the flow log. Default value: `plain-text`. Valid values: `plain-text`, `parquet`.
     */
    @JvmName("wcsceluyyhlfogtq")
    public suspend fun fileFormat(`value`: Output<String>) {
        this.fileFormat = value
    }

    /**
     * @param value Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. Default value: `false`.
     */
    @JvmName("bduetcbvtmobgucn")
    public suspend fun hiveCompatiblePartitions(`value`: Output<Boolean>) {
        this.hiveCompatiblePartitions = value
    }

    /**
     * @param value Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries. Default value: `false`.
     */
    @JvmName("wvgfmhvotqxfdfsp")
    public suspend fun perHourPartition(`value`: Output<Boolean>) {
        this.perHourPartition = value
    }

    /**
     * @param value The format for the flow log. Default value: `plain-text`. Valid values: `plain-text`, `parquet`.
     */
    @JvmName("feluagtmdepxwron")
    public suspend fun fileFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFormat = mapped
    }

    /**
     * @param value Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. Default value: `false`.
     */
    @JvmName("aqumnlavvkqprfyn")
    public suspend fun hiveCompatiblePartitions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hiveCompatiblePartitions = mapped
    }

    /**
     * @param value Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries. Default value: `false`.
     */
    @JvmName("iwixsmsyugqtnwlp")
    public suspend fun perHourPartition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perHourPartition = mapped
    }

    internal fun build(): FlowLogDestinationOptionsArgs = FlowLogDestinationOptionsArgs(
        fileFormat = fileFormat,
        hiveCompatiblePartitions = hiveCompatiblePartitions,
        perHourPartition = perHourPartition,
    )
}
