@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetAmiIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAmiIds.
 * @property executableUsers Limit search to users with *explicit* launch
 * permission on  the image. Valid items are the numeric account ID or `self`.
 * @property filters One or more name/value pairs to filter off of. There
 * are several valid keys, for a full reference, check out
 * [describe-images in the AWS CLI reference][1].
 * @property includeDeprecated If true, all deprecated AMIs are included in the response.
 * If false, no deprecated AMIs are included in the response. If no value is specified, the default value is `false`.
 * @property nameRegex Regex string to apply to the AMI list returned
 * by AWS. This allows more advanced filtering not supported from the AWS API.
 * This filtering is done locally on what AWS returns, and could have a performance
 * impact if the result is large. Combine this with other
 * options to narrow down the list AWS returns.
 * @property owners List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
 * @property sortAscending Used to sort AMIs by creation time.
 * If no value is specified, the default value is `false`.
 */
public data class GetAmiIdsPlainArgs(
    public val executableUsers: List<String>? = null,
    public val filters: List<GetAmiIdsFilter>? = null,
    public val includeDeprecated: Boolean? = null,
    public val nameRegex: String? = null,
    public val owners: List<String>,
    public val sortAscending: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetAmiIdsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetAmiIdsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetAmiIdsPlainArgs.builder()
            .executableUsers(executableUsers?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .includeDeprecated(includeDeprecated?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .owners(owners.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .sortAscending(sortAscending?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAmiIdsPlainArgs].
 */
@PulumiTagMarker
public class GetAmiIdsPlainArgsBuilder internal constructor() {
    private var executableUsers: List<String>? = null

    private var filters: List<GetAmiIdsFilter>? = null

    private var includeDeprecated: Boolean? = null

    private var nameRegex: String? = null

    private var owners: List<String>? = null

    private var sortAscending: Boolean? = null

    /**
     * @param value Limit search to users with *explicit* launch
     * permission on  the image. Valid items are the numeric account ID or `self`.
     */
    @JvmName("dtcelqmkrrqbpihg")
    public suspend fun executableUsers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.executableUsers = mapped
    }

    /**
     * @param values Limit search to users with *explicit* launch
     * permission on  the image. Valid items are the numeric account ID or `self`.
     */
    @JvmName("kpyqljujamrdjvnk")
    public suspend fun executableUsers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.executableUsers = mapped
    }

    /**
     * @param value One or more name/value pairs to filter off of. There
     * are several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("nrnfulagxfhetspg")
    public suspend fun filters(`value`: List<GetAmiIdsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There
     * are several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("resaoojmbbmtmrpr")
    public suspend fun filters(argument: List<suspend GetAmiIdsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetAmiIdsFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There
     * are several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("smdroyfsjfchmame")
    public suspend fun filters(vararg argument: suspend GetAmiIdsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetAmiIdsFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There
     * are several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("obhcmkaeerymmqgh")
    public suspend fun filters(argument: suspend GetAmiIdsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetAmiIdsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to filter off of. There
     * are several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("wrkvmcwnprlkdjab")
    public suspend fun filters(vararg values: GetAmiIdsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value If true, all deprecated AMIs are included in the response.
     * If false, no deprecated AMIs are included in the response. If no value is specified, the default value is `false`.
     */
    @JvmName("vvayndpmjbwdnayf")
    public suspend fun includeDeprecated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeDeprecated = mapped
    }

    /**
     * @param value Regex string to apply to the AMI list returned
     * by AWS. This allows more advanced filtering not supported from the AWS API.
     * This filtering is done locally on what AWS returns, and could have a performance
     * impact if the result is large. Combine this with other
     * options to narrow down the list AWS returns.
     */
    @JvmName("xkkkyuhmnxdvrgxd")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
     */
    @JvmName("kweokokwktufdioq")
    public suspend fun owners(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param values List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
     */
    @JvmName("rspmtdjpcmodsbqe")
    public suspend fun owners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param value Used to sort AMIs by creation time.
     * If no value is specified, the default value is `false`.
     */
    @JvmName("oxlnnajxoyvuadpq")
    public suspend fun sortAscending(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortAscending = mapped
    }

    internal fun build(): GetAmiIdsPlainArgs = GetAmiIdsPlainArgs(
        executableUsers = executableUsers,
        filters = filters,
        includeDeprecated = includeDeprecated,
        nameRegex = nameRegex,
        owners = owners ?: throw PulumiNullFieldException("owners"),
        sortAscending = sortAscending,
    )
}
