@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetAmiPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAmi.
 * @property executableUsers Limit search to users with *explicit* launch permission on
 * the image. Valid items are the numeric account ID or `self`.
 * @property filters One or more name/value pairs to filter off of. There are
 * several valid keys, for a full reference, check out
 * [describe-images in the AWS CLI reference][1].
 * @property includeDeprecated If true, all deprecated AMIs are included in the response. If false, no deprecated AMIs are included in the response. If no value is specified, the default value is false.
 * @property mostRecent If more than one result is returned, use the most
 * recent AMI.
 * @property nameRegex Regex string to apply to the AMI list returned
 * by AWS. This allows more advanced filtering not supported from the AWS API. This
 * filtering is done locally on what AWS returns, and could have a performance
 * impact if the result is large. Combine this with other
 * options to narrow down the list AWS returns.
 * > **NOTE:** If more or less than a single match is returned by the search,
 * this call will fail. Ensure that your search is specific enough to return
 * a single AMI ID only, or use `most_recent` to choose the most recent one. If
 * you want to match multiple AMIs, use the `aws.ec2.getAmiIds` data source instead.
 * @property owners List of AMI owners to limit search. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
 * @property tags Any tags assigned to the image.
 * * `tags.#.key` - Key name of the tag.
 * * `tags.#.value` - Value of the tag.
 */
public data class GetAmiPlainArgs(
    public val executableUsers: List<String>? = null,
    public val filters: List<GetAmiFilter>? = null,
    public val includeDeprecated: Boolean? = null,
    public val mostRecent: Boolean? = null,
    public val nameRegex: String? = null,
    public val owners: List<String>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetAmiPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetAmiPlainArgs =
        com.pulumi.aws.ec2.inputs.GetAmiPlainArgs.builder()
            .executableUsers(executableUsers?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .includeDeprecated(includeDeprecated?.let({ args0 -> args0 }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .owners(owners?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetAmiPlainArgs].
 */
@PulumiTagMarker
public class GetAmiPlainArgsBuilder internal constructor() {
    private var executableUsers: List<String>? = null

    private var filters: List<GetAmiFilter>? = null

    private var includeDeprecated: Boolean? = null

    private var mostRecent: Boolean? = null

    private var nameRegex: String? = null

    private var owners: List<String>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Limit search to users with *explicit* launch permission on
     * the image. Valid items are the numeric account ID or `self`.
     */
    @JvmName("snhgyxxwhxxeiqtr")
    public suspend fun executableUsers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.executableUsers = mapped
    }

    /**
     * @param values Limit search to users with *explicit* launch permission on
     * the image. Valid items are the numeric account ID or `self`.
     */
    @JvmName("qotibdylmejvtdoh")
    public suspend fun executableUsers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.executableUsers = mapped
    }

    /**
     * @param value One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("sygqrcnnopweepia")
    public suspend fun filters(`value`: List<GetAmiFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("oxrevkpwegdgtoow")
    public suspend fun filters(argument: List<suspend GetAmiFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetAmiFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("uamwxokyyxdivbro")
    public suspend fun filters(vararg argument: suspend GetAmiFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetAmiFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("joxvthofdokwdiqj")
    public suspend fun filters(argument: suspend GetAmiFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetAmiFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     */
    @JvmName("rocljqiwsxstrqwa")
    public suspend fun filters(vararg values: GetAmiFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value If true, all deprecated AMIs are included in the response. If false, no deprecated AMIs are included in the response. If no value is specified, the default value is false.
     */
    @JvmName("nxiggsaoqkivinoy")
    public suspend fun includeDeprecated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeDeprecated = mapped
    }

    /**
     * @param value If more than one result is returned, use the most
     * recent AMI.
     */
    @JvmName("triglfafcujapufw")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value Regex string to apply to the AMI list returned
     * by AWS. This allows more advanced filtering not supported from the AWS API. This
     * filtering is done locally on what AWS returns, and could have a performance
     * impact if the result is large. Combine this with other
     * options to narrow down the list AWS returns.
     * > **NOTE:** If more or less than a single match is returned by the search,
     * this call will fail. Ensure that your search is specific enough to return
     * a single AMI ID only, or use `most_recent` to choose the most recent one. If
     * you want to match multiple AMIs, use the `aws.ec2.getAmiIds` data source instead.
     */
    @JvmName("vjsvsesqcbdslntr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value List of AMI owners to limit search. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
     */
    @JvmName("qivjlcjmbjrjehew")
    public suspend fun owners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param values List of AMI owners to limit search. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
     */
    @JvmName("sfnofsxhadrbqmbf")
    public suspend fun owners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param value Any tags assigned to the image.
     * * `tags.#.key` - Key name of the tag.
     * * `tags.#.value` - Value of the tag.
     */
    @JvmName("milcktcfvxhtihdd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Any tags assigned to the image.
     * * `tags.#.key` - Key name of the tag.
     * * `tags.#.value` - Value of the tag.
     */
    @JvmName("osmfbtnacxpnaqtk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetAmiPlainArgs = GetAmiPlainArgs(
        executableUsers = executableUsers,
        filters = filters,
        includeDeprecated = includeDeprecated,
        mostRecent = mostRecent,
        nameRegex = nameRegex,
        owners = owners,
        tags = tags,
    )
}
