@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetCapacityBlockOfferingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCapacityBlockOffering.
 * @property capacityDurationHours The amount of time of the Capacity Block reservation in hours.
 * @property endDateRange The date and time at which the Capacity Block Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
 * @property instanceCount The number of instances for which to reserve capacity.
 * @property instanceType The instance type for which to reserve capacity.
 * @property startDateRange The date and time at which the Capacity Block Reservation starts. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
 */
public data class GetCapacityBlockOfferingPlainArgs(
    public val capacityDurationHours: Int,
    public val endDateRange: String? = null,
    public val instanceCount: Int,
    public val instanceType: String,
    public val startDateRange: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetCapacityBlockOfferingPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetCapacityBlockOfferingPlainArgs =
        com.pulumi.aws.ec2.inputs.GetCapacityBlockOfferingPlainArgs.builder()
            .capacityDurationHours(capacityDurationHours.let({ args0 -> args0 }))
            .endDateRange(endDateRange?.let({ args0 -> args0 }))
            .instanceCount(instanceCount.let({ args0 -> args0 }))
            .instanceType(instanceType.let({ args0 -> args0 }))
            .startDateRange(startDateRange?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCapacityBlockOfferingPlainArgs].
 */
@PulumiTagMarker
public class GetCapacityBlockOfferingPlainArgsBuilder internal constructor() {
    private var capacityDurationHours: Int? = null

    private var endDateRange: String? = null

    private var instanceCount: Int? = null

    private var instanceType: String? = null

    private var startDateRange: String? = null

    /**
     * @param value The amount of time of the Capacity Block reservation in hours.
     */
    @JvmName("hhvcydxrlqupvuqj")
    public suspend fun capacityDurationHours(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.capacityDurationHours = mapped
    }

    /**
     * @param value The date and time at which the Capacity Block Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("khdclovavxsmxcnq")
    public suspend fun endDateRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endDateRange = mapped
    }

    /**
     * @param value The number of instances for which to reserve capacity.
     */
    @JvmName("rjyupcqmsuiqowuy")
    public suspend fun instanceCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceCount = mapped
    }

    /**
     * @param value The instance type for which to reserve capacity.
     */
    @JvmName("rawufukmbsyjjyuo")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value The date and time at which the Capacity Block Reservation starts. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("aghqemehjwupcoiu")
    public suspend fun startDateRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startDateRange = mapped
    }

    internal fun build(): GetCapacityBlockOfferingPlainArgs = GetCapacityBlockOfferingPlainArgs(
        capacityDurationHours = capacityDurationHours ?: throw
            PulumiNullFieldException("capacityDurationHours"),
        endDateRange = endDateRange,
        instanceCount = instanceCount ?: throw PulumiNullFieldException("instanceCount"),
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        startDateRange = startDateRange,
    )
}
