@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetCoipPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCoipPool.
 * @property filters
 * @property localGatewayRouteTableId Local Gateway Route Table Id assigned to desired COIP Pool
 * @property poolId ID of the specific COIP Pool to retrieve.
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the desired COIP Pool.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetCoipPoolPlainArgs(
    public val filters: List<GetCoipPoolFilter>? = null,
    public val localGatewayRouteTableId: String? = null,
    public val poolId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetCoipPoolPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetCoipPoolPlainArgs =
        com.pulumi.aws.ec2.inputs.GetCoipPoolPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .localGatewayRouteTableId(localGatewayRouteTableId?.let({ args0 -> args0 }))
            .poolId(poolId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetCoipPoolPlainArgs].
 */
@PulumiTagMarker
public class GetCoipPoolPlainArgsBuilder internal constructor() {
    private var filters: List<GetCoipPoolFilter>? = null

    private var localGatewayRouteTableId: String? = null

    private var poolId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value
     */
    @JvmName("athdsdywwekmrcvc")
    public suspend fun filters(`value`: List<GetCoipPoolFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("myercjqtjqvhcrnh")
    public suspend fun filters(argument: List<suspend GetCoipPoolFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoipPoolFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cuuydrqqisrhjrhs")
    public suspend fun filters(vararg argument: suspend GetCoipPoolFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoipPoolFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cwvfupshahbngmcn")
    public suspend fun filters(argument: suspend GetCoipPoolFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetCoipPoolFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values
     */
    @JvmName("trmfphamfldsvsnj")
    public suspend fun filters(vararg values: GetCoipPoolFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Local Gateway Route Table Id assigned to desired COIP Pool
     */
    @JvmName("jnoayhmpedbykech")
    public suspend fun localGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.localGatewayRouteTableId = mapped
    }

    /**
     * @param value ID of the specific COIP Pool to retrieve.
     */
    @JvmName("nyqkjowwejalgtmn")
    public suspend fun poolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.poolId = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the desired COIP Pool.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("elciolrrfcaxqxvt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the desired COIP Pool.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("jwbyjeqxvepdaatp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetCoipPoolPlainArgs = GetCoipPoolPlainArgs(
        filters = filters,
        localGatewayRouteTableId = localGatewayRouteTableId,
        poolId = poolId,
        tags = tags,
    )
}
