@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetCoipPoolsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCoipPools.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the desired aws_ec2_coip_pools.
 */
public data class GetCoipPoolsPlainArgs(
    public val filters: List<GetCoipPoolsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetCoipPoolsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetCoipPoolsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetCoipPoolsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetCoipPoolsPlainArgs].
 */
@PulumiTagMarker
public class GetCoipPoolsPlainArgsBuilder internal constructor() {
    private var filters: List<GetCoipPoolsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("patjpfnxpbaeixlk")
    public suspend fun filters(`value`: List<GetCoipPoolsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("rsrhgnxejnmkbgbo")
    public suspend fun filters(argument: List<suspend GetCoipPoolsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoipPoolsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("dxfoavtcsljmmyaj")
    public suspend fun filters(vararg argument: suspend GetCoipPoolsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoipPoolsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("ehcrhtbeikneyacn")
    public suspend fun filters(argument: suspend GetCoipPoolsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetCoipPoolsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("owrwyyicalruaxej")
    public suspend fun filters(vararg values: GetCoipPoolsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the desired aws_ec2_coip_pools.
     */
    @JvmName("olbpxsqexrodmoli")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the desired aws_ec2_coip_pools.
     */
    @JvmName("auniajevwmmhsjau")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetCoipPoolsPlainArgs = GetCoipPoolsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
