@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetDedicatedHostPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDedicatedHost.
 * @property filters Configuration block. Detailed below.
 * @property hostId ID of the Dedicated Host.
 * @property tags
 */
public data class GetDedicatedHostPlainArgs(
    public val filters: List<GetDedicatedHostFilter>? = null,
    public val hostId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetDedicatedHostPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetDedicatedHostPlainArgs =
        com.pulumi.aws.ec2.inputs.GetDedicatedHostPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .hostId(hostId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDedicatedHostPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedHostPlainArgsBuilder internal constructor() {
    private var filters: List<GetDedicatedHostFilter>? = null

    private var hostId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("lutlulclphsgrbly")
    public suspend fun filters(`value`: List<GetDedicatedHostFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("mkgciyarraxvemwv")
    public suspend fun filters(argument: List<suspend GetDedicatedHostFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDedicatedHostFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("asbipaepgfbmqssi")
    public suspend fun filters(vararg argument: suspend GetDedicatedHostFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetDedicatedHostFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("csocrsemxhewvuij")
    public suspend fun filters(argument: suspend GetDedicatedHostFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetDedicatedHostFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("ygdruegejaeysmqo")
    public suspend fun filters(vararg values: GetDedicatedHostFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the Dedicated Host.
     */
    @JvmName("bwxpqdmhoajycmnc")
    public suspend fun hostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostId = mapped
    }

    /**
     * @param value
     */
    @JvmName("kagweuhiwtpupsqn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("wdpkmeiwxmqcdaoi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDedicatedHostPlainArgs = GetDedicatedHostPlainArgs(
        filters = filters,
        hostId = hostId,
        tags = tags,
    )
}
