@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetEipsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEips.
 * @property filters Custom filter block as described below.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
 */
public data class GetEipsPlainArgs(
    public val filters: List<GetEipsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetEipsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetEipsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetEipsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEipsPlainArgs].
 */
@PulumiTagMarker
public class GetEipsPlainArgsBuilder internal constructor() {
    private var filters: List<GetEipsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("eoospathujbfnjjj")
    public suspend fun filters(`value`: List<GetEipsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("frvgubfgkpcmawvl")
    public suspend fun filters(argument: List<suspend GetEipsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetEipsFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("alxjewdtyshtxpdb")
    public suspend fun filters(vararg argument: suspend GetEipsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetEipsFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("rglubrwhomlojkvp")
    public suspend fun filters(argument: suspend GetEipsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetEipsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("xpqttogcmqgipbps")
    public suspend fun filters(vararg values: GetEipsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
     */
    @JvmName("cadglcqlkqkkckss")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
     */
    @JvmName("hajbrhbvijiddtsk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEipsPlainArgs = GetEipsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
