@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetElasticIpPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getElasticIp.
 * @property filters One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
 * @property id Allocation ID of the specific VPC EIP to retrieve. If a classic EIP is required, do NOT set `id`, only set `public_ip`
 * @property publicIp Public IP of the specific EIP to retrieve.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired Elastic IP
 */
public data class GetElasticIpPlainArgs(
    public val filters: List<GetElasticIpFilter>? = null,
    public val id: String? = null,
    public val publicIp: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetElasticIpPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetElasticIpPlainArgs =
        com.pulumi.aws.ec2.inputs.GetElasticIpPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .publicIp(publicIp?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetElasticIpPlainArgs].
 */
@PulumiTagMarker
public class GetElasticIpPlainArgsBuilder internal constructor() {
    private var filters: List<GetElasticIpFilter>? = null

    private var id: String? = null

    private var publicIp: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
     */
    @JvmName("uwtfxlfhohmuehsm")
    public suspend fun filters(`value`: List<GetElasticIpFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
     */
    @JvmName("wleqylmhhhadejye")
    public suspend fun filters(argument: List<suspend GetElasticIpFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetElasticIpFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
     */
    @JvmName("oodbbslqathsfmlq")
    public suspend fun filters(vararg argument: suspend GetElasticIpFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetElasticIpFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
     */
    @JvmName("idiymejtkalmvdtu")
    public suspend fun filters(argument: suspend GetElasticIpFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetElasticIpFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
     */
    @JvmName("gctfwjopdouswwcd")
    public suspend fun filters(vararg values: GetElasticIpFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Allocation ID of the specific VPC EIP to retrieve. If a classic EIP is required, do NOT set `id`, only set `public_ip`
     */
    @JvmName("rnevxjhsefdoytpb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Public IP of the specific EIP to retrieve.
     */
    @JvmName("ueidwooekhnbqxfr")
    public suspend fun publicIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.publicIp = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired Elastic IP
     */
    @JvmName("mpslkranrxledpbt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired Elastic IP
     */
    @JvmName("wqeknlfgrtginnlx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetElasticIpPlainArgs = GetElasticIpPlainArgs(
        filters = filters,
        id = id,
        publicIp = publicIp,
        tags = tags,
    )
}
