@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypeOffering.
 * @property filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
 * @property locationType Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
 * @property preferredInstanceTypes Ordered list of preferred EC2 Instance Types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
 */
public data class GetInstanceTypeOfferingPlainArgs(
    public val filters: List<GetInstanceTypeOfferingFilter>? = null,
    public val locationType: String? = null,
    public val preferredInstanceTypes: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingPlainArgs =
        com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .locationType(locationType?.let({ args0 -> args0 }))
            .preferredInstanceTypes(
                preferredInstanceTypes?.let({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [GetInstanceTypeOfferingPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypeOfferingPlainArgsBuilder internal constructor() {
    private var filters: List<GetInstanceTypeOfferingFilter>? = null

    private var locationType: String? = null

    private var preferredInstanceTypes: List<String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("kqflljllnvfaetdl")
    public suspend fun filters(`value`: List<GetInstanceTypeOfferingFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("jliqyrgilwmxigrl")
    public suspend fun filters(argument: List<suspend GetInstanceTypeOfferingFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInstanceTypeOfferingFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("vufrykkgnvedybkb")
    public suspend fun filters(vararg argument: suspend GetInstanceTypeOfferingFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInstanceTypeOfferingFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("fgfgqutcosewdtjo")
    public suspend fun filters(argument: suspend GetInstanceTypeOfferingFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetInstanceTypeOfferingFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("agkdrehlncvsrfmg")
    public suspend fun filters(vararg values: GetInstanceTypeOfferingFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
     */
    @JvmName("kudqkcnvbgisxgyf")
    public suspend fun locationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.locationType = mapped
    }

    /**
     * @param value Ordered list of preferred EC2 Instance Types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("fjrbtultgycnrbul")
    public suspend fun preferredInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredInstanceTypes = mapped
    }

    /**
     * @param values Ordered list of preferred EC2 Instance Types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("glykyrwljhfvqiue")
    public suspend fun preferredInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredInstanceTypes = mapped
    }

    internal fun build(): GetInstanceTypeOfferingPlainArgs = GetInstanceTypeOfferingPlainArgs(
        filters = filters,
        locationType = locationType,
        preferredInstanceTypes = preferredInstanceTypes,
    )
}
