@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypeOfferings.
 * @property filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
 * @property locationType Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
 */
public data class GetInstanceTypeOfferingsPlainArgs(
    public val filters: List<GetInstanceTypeOfferingsFilter>? = null,
    public val locationType: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .locationType(locationType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceTypeOfferingsPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypeOfferingsPlainArgsBuilder internal constructor() {
    private var filters: List<GetInstanceTypeOfferingsFilter>? = null

    private var locationType: String? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("xvtluvwsbaqmsedb")
    public suspend fun filters(`value`: List<GetInstanceTypeOfferingsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("nayrlagxvywryrgs")
    public suspend fun filters(argument: List<suspend GetInstanceTypeOfferingsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInstanceTypeOfferingsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("klxsimgdrxutqgxy")
    public suspend fun filters(vararg argument: suspend GetInstanceTypeOfferingsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInstanceTypeOfferingsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("miccabgcpsdwbgni")
    public suspend fun filters(argument: suspend GetInstanceTypeOfferingsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetInstanceTypeOfferingsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     */
    @JvmName("hrvohoxowuxcihns")
    public suspend fun filters(vararg values: GetInstanceTypeOfferingsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
     */
    @JvmName("ttxhuvbrfodyhxfi")
    public suspend fun locationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.locationType = mapped
    }

    internal fun build(): GetInstanceTypeOfferingsPlainArgs = GetInstanceTypeOfferingsPlainArgs(
        filters = filters,
        locationType = locationType,
    )
}
