@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetInstanceTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceType.
 * @property instanceType Instance
 */
public data class GetInstanceTypePlainArgs(
    public val instanceType: String,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetInstanceTypePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetInstanceTypePlainArgs =
        com.pulumi.aws.ec2.inputs.GetInstanceTypePlainArgs.builder()
            .instanceType(instanceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceTypePlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypePlainArgsBuilder internal constructor() {
    private var instanceType: String? = null

    /**
     * @param value Instance
     */
    @JvmName("mpovmstvjsknllka")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    internal fun build(): GetInstanceTypePlainArgs = GetInstanceTypePlainArgs(
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
    )
}
