@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetInstanceTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypes.
 * @property filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html) for supported filters. Detailed below.
 */
public data class GetInstanceTypesPlainArgs(
    public val filters: List<GetInstanceTypesFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetInstanceTypesPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetInstanceTypesPlainArgs =
        com.pulumi.aws.ec2.inputs.GetInstanceTypesPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetInstanceTypesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypesPlainArgsBuilder internal constructor() {
    private var filters: List<GetInstanceTypesFilter>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html) for supported filters. Detailed below.
     */
    @JvmName("rffusausgrlejwos")
    public suspend fun filters(`value`: List<GetInstanceTypesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html) for supported filters. Detailed below.
     */
    @JvmName("uavibwuhfrixwdcn")
    public suspend fun filters(argument: List<suspend GetInstanceTypesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInstanceTypesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html) for supported filters. Detailed below.
     */
    @JvmName("ketcdfloflgcimug")
    public suspend fun filters(vararg argument: suspend GetInstanceTypesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInstanceTypesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html) for supported filters. Detailed below.
     */
    @JvmName("imgheekysalopukj")
    public suspend fun filters(argument: suspend GetInstanceTypesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetInstanceTypesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html) for supported filters. Detailed below.
     */
    @JvmName("kkialjwsnjmdkmdg")
    public suspend fun filters(vararg values: GetInstanceTypesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetInstanceTypesPlainArgs = GetInstanceTypesPlainArgs(
        filters = filters,
    )
}
