@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetIpamPreviewNextCidrPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpamPreviewNextCidr.
 * @property disallowedCidrs Exclude a particular CIDR range from being returned by the pool.
 * @property ipamPoolId ID of the pool to which you want to assign a CIDR.
 * @property netmaskLength Netmask length of the CIDR you would like to preview from the IPAM pool.
 */
public data class GetIpamPreviewNextCidrPlainArgs(
    public val disallowedCidrs: List<String>? = null,
    public val ipamPoolId: String,
    public val netmaskLength: Int? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetIpamPreviewNextCidrPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetIpamPreviewNextCidrPlainArgs =
        com.pulumi.aws.ec2.inputs.GetIpamPreviewNextCidrPlainArgs.builder()
            .disallowedCidrs(disallowedCidrs?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipamPoolId(ipamPoolId.let({ args0 -> args0 }))
            .netmaskLength(netmaskLength?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpamPreviewNextCidrPlainArgs].
 */
@PulumiTagMarker
public class GetIpamPreviewNextCidrPlainArgsBuilder internal constructor() {
    private var disallowedCidrs: List<String>? = null

    private var ipamPoolId: String? = null

    private var netmaskLength: Int? = null

    /**
     * @param value Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("qjwrfmkrlevfcbal")
    public suspend fun disallowedCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.disallowedCidrs = mapped
    }

    /**
     * @param values Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("frrkqhyingbpfgqx")
    public suspend fun disallowedCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.disallowedCidrs = mapped
    }

    /**
     * @param value ID of the pool to which you want to assign a CIDR.
     */
    @JvmName("ondkpplcttbxnxto")
    public suspend fun ipamPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipamPoolId = mapped
    }

    /**
     * @param value Netmask length of the CIDR you would like to preview from the IPAM pool.
     */
    @JvmName("ifnmkkakirnqvfpg")
    public suspend fun netmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.netmaskLength = mapped
    }

    internal fun build(): GetIpamPreviewNextCidrPlainArgs = GetIpamPreviewNextCidrPlainArgs(
        disallowedCidrs = disallowedCidrs,
        ipamPoolId = ipamPoolId ?: throw PulumiNullFieldException("ipamPoolId"),
        netmaskLength = netmaskLength,
    )
}
