@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetKeyPairPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKeyPair.
 * @property filters Custom filter block as described below.
 * @property includePublicKey Whether to include the public key material in the response.
 * @property keyName Key Pair name.
 * @property keyPairId Key Pair ID.
 * @property tags Any tags assigned to the Key Pair.
 */
public data class GetKeyPairPlainArgs(
    public val filters: List<GetKeyPairFilter>? = null,
    public val includePublicKey: Boolean? = null,
    public val keyName: String? = null,
    public val keyPairId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetKeyPairPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetKeyPairPlainArgs =
        com.pulumi.aws.ec2.inputs.GetKeyPairPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .includePublicKey(includePublicKey?.let({ args0 -> args0 }))
            .keyName(keyName?.let({ args0 -> args0 }))
            .keyPairId(keyPairId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetKeyPairPlainArgs].
 */
@PulumiTagMarker
public class GetKeyPairPlainArgsBuilder internal constructor() {
    private var filters: List<GetKeyPairFilter>? = null

    private var includePublicKey: Boolean? = null

    private var keyName: String? = null

    private var keyPairId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("ahnhmshkynswfivm")
    public suspend fun filters(`value`: List<GetKeyPairFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("sekkgjmvvutiebbo")
    public suspend fun filters(argument: List<suspend GetKeyPairFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetKeyPairFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("qntqbmyylqysnibx")
    public suspend fun filters(vararg argument: suspend GetKeyPairFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetKeyPairFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("kcihyqnmuucaukla")
    public suspend fun filters(argument: suspend GetKeyPairFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetKeyPairFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("iemhiudfwkkkjukm")
    public suspend fun filters(vararg values: GetKeyPairFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Whether to include the public key material in the response.
     */
    @JvmName("raevnnkoqftxadoq")
    public suspend fun includePublicKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includePublicKey = mapped
    }

    /**
     * @param value Key Pair name.
     */
    @JvmName("vcljuopdbgdklxrb")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyName = mapped
    }

    /**
     * @param value Key Pair ID.
     */
    @JvmName("nvkrudolqkwwtjyg")
    public suspend fun keyPairId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyPairId = mapped
    }

    /**
     * @param value Any tags assigned to the Key Pair.
     */
    @JvmName("wpxdnmbtktgxynfs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Any tags assigned to the Key Pair.
     */
    @JvmName("akplajjhemmiavbl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetKeyPairPlainArgs = GetKeyPairPlainArgs(
        filters = filters,
        includePublicKey = includePublicKey,
        keyName = keyName,
        keyPairId = keyPairId,
        tags = tags,
    )
}
