@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLocalGatewayVirtualInterfaceGroup.
 * @property filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
 * @property id Identifier of EC2 Local Gateway Virtual Interface Group.
 * @property localGatewayId Identifier of EC2 Local Gateway.
 * @property tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
 */
public data class GetLocalGatewayVirtualInterfaceGroupPlainArgs(
    public val filters: List<GetLocalGatewayVirtualInterfaceGroupFilter>? = null,
    public val id: String? = null,
    public val localGatewayId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupPlainArgs =
        com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .localGatewayId(localGatewayId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLocalGatewayVirtualInterfaceGroupPlainArgs].
 */
@PulumiTagMarker
public class GetLocalGatewayVirtualInterfaceGroupPlainArgsBuilder internal constructor() {
    private var filters: List<GetLocalGatewayVirtualInterfaceGroupFilter>? = null

    private var id: String? = null

    private var localGatewayId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("hbbyjibuiprbimxc")
    public suspend fun filters(`value`: List<GetLocalGatewayVirtualInterfaceGroupFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("rlkpsildqbltnqrj")
    public suspend fun filters(argument: List<suspend GetLocalGatewayVirtualInterfaceGroupFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayVirtualInterfaceGroupFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("usrkqhpbnphtfiyj")
    public suspend fun filters(vararg argument: suspend GetLocalGatewayVirtualInterfaceGroupFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayVirtualInterfaceGroupFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("ruyqgwodtmocohsq")
    public suspend fun filters(argument: suspend GetLocalGatewayVirtualInterfaceGroupFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetLocalGatewayVirtualInterfaceGroupFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("omtmbvmimnxorcgm")
    public suspend fun filters(vararg values: GetLocalGatewayVirtualInterfaceGroupFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of EC2 Local Gateway Virtual Interface Group.
     */
    @JvmName("gfveufjacqdhpykb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Identifier of EC2 Local Gateway.
     */
    @JvmName("ealuonqbaghlxmgw")
    public suspend fun localGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.localGatewayId = mapped
    }

    /**
     * @param value Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     */
    @JvmName("pynvuvekgtdxdphj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     */
    @JvmName("mgddxbgagdcbmgud")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLocalGatewayVirtualInterfaceGroupPlainArgs =
        GetLocalGatewayVirtualInterfaceGroupPlainArgs(
            filters = filters,
            id = id,
            localGatewayId = localGatewayId,
            tags = tags,
        )
}
