@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the filter.
 * @property values List of one or more values for the filter.
 */
public data class GetLocalGatewayVirtualInterfaceGroupsFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsFilter> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsFilter =
        com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetLocalGatewayVirtualInterfaceGroupsFilter].
 */
@PulumiTagMarker
public class GetLocalGatewayVirtualInterfaceGroupsFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value Name of the filter.
     */
    @JvmName("afusrrslidqsigej")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value List of one or more values for the filter.
     */
    @JvmName("gahyyqlyftqonjkn")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values List of one or more values for the filter.
     */
    @JvmName("mmhxifiukocxnpao")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetLocalGatewayVirtualInterfaceGroupsFilter =
        GetLocalGatewayVirtualInterfaceGroupsFilter(
            name = name ?: throw PulumiNullFieldException("name"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
