@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLocalGatewayVirtualInterface.
 * @property filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html) for supported filters. Detailed below.
 * @property id Identifier of EC2 Local Gateway Virtual Interface.
 * @property tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
 */
public data class GetLocalGatewayVirtualInterfacePlainArgs(
    public val filters: List<GetLocalGatewayVirtualInterfaceFilter>? = null,
    public val id: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfacePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfacePlainArgs =
        com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfacePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLocalGatewayVirtualInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetLocalGatewayVirtualInterfacePlainArgsBuilder internal constructor() {
    private var filters: List<GetLocalGatewayVirtualInterfaceFilter>? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html) for supported filters. Detailed below.
     */
    @JvmName("kelbjqvuoprlyyqt")
    public suspend fun filters(`value`: List<GetLocalGatewayVirtualInterfaceFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html) for supported filters. Detailed below.
     */
    @JvmName("oxvwhlotoheyvnxd")
    public suspend fun filters(argument: List<suspend GetLocalGatewayVirtualInterfaceFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayVirtualInterfaceFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html) for supported filters. Detailed below.
     */
    @JvmName("rylrqcmwgkcwbmva")
    public suspend fun filters(vararg argument: suspend GetLocalGatewayVirtualInterfaceFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayVirtualInterfaceFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html) for supported filters. Detailed below.
     */
    @JvmName("hoagxpalbfwpchyv")
    public suspend fun filters(argument: suspend GetLocalGatewayVirtualInterfaceFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetLocalGatewayVirtualInterfaceFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html) for supported filters. Detailed below.
     */
    @JvmName("jyehpligvxfmcibo")
    public suspend fun filters(vararg values: GetLocalGatewayVirtualInterfaceFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of EC2 Local Gateway Virtual Interface.
     */
    @JvmName("enrqvogeoqyfbxoy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     */
    @JvmName("enjlvenxoqkcnjam")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     */
    @JvmName("inrmivlxbrkbvvuc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLocalGatewayVirtualInterfacePlainArgs =
        GetLocalGatewayVirtualInterfacePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
}
