@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLocalGatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLocalGateways.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the desired local_gateways.
 */
public data class GetLocalGatewaysPlainArgs(
    public val filters: List<GetLocalGatewaysFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLocalGatewaysPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLocalGatewaysPlainArgs =
        com.pulumi.aws.ec2.inputs.GetLocalGatewaysPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLocalGatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetLocalGatewaysPlainArgsBuilder internal constructor() {
    private var filters: List<GetLocalGatewaysFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("nsvekodrxxwwofxs")
    public suspend fun filters(`value`: List<GetLocalGatewaysFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("scjjlnkfbhgtbkdd")
    public suspend fun filters(argument: List<suspend GetLocalGatewaysFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewaysFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("jtemafihxmpoqnpw")
    public suspend fun filters(vararg argument: suspend GetLocalGatewaysFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewaysFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("ssovxumntuxaepau")
    public suspend fun filters(argument: suspend GetLocalGatewaysFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetLocalGatewaysFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("fsgeffmthhhxgoya")
    public suspend fun filters(vararg values: GetLocalGatewaysFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the desired local_gateways.
     */
    @JvmName("lefbgwpjiivautva")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the desired local_gateways.
     */
    @JvmName("rvqwlvlqfkdaafoc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLocalGatewaysPlainArgs = GetLocalGatewaysPlainArgs(
        filters = filters,
        tags = tags,
    )
}
