@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetManagedPrefixListPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getManagedPrefixList.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property id ID of the prefix list to select.
 * @property name Name of the prefix list to select.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetManagedPrefixListPlainArgs(
    public val filters: List<GetManagedPrefixListFilter>? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetManagedPrefixListPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetManagedPrefixListPlainArgs =
        com.pulumi.aws.ec2.inputs.GetManagedPrefixListPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetManagedPrefixListPlainArgs].
 */
@PulumiTagMarker
public class GetManagedPrefixListPlainArgsBuilder internal constructor() {
    private var filters: List<GetManagedPrefixListFilter>? = null

    private var id: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("wlpaxxpdcusisfta")
    public suspend fun filters(`value`: List<GetManagedPrefixListFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("bixbbmyynxfvbbtb")
    public suspend fun filters(argument: List<suspend GetManagedPrefixListFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetManagedPrefixListFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("xhhgoarqochnipod")
    public suspend fun filters(vararg argument: suspend GetManagedPrefixListFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetManagedPrefixListFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("drlputnbosfrrcip")
    public suspend fun filters(argument: suspend GetManagedPrefixListFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetManagedPrefixListFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("thxqxyhejbdfjicd")
    public suspend fun filters(vararg values: GetManagedPrefixListFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the prefix list to select.
     */
    @JvmName("cdnwbkbtuxpvnwqt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the prefix list to select.
     */
    @JvmName("wytaqtsqyhhfehsb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("bpuibntgyduiqhew")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("stmgsdqbtsrsoymq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetManagedPrefixListPlainArgs = GetManagedPrefixListPlainArgs(
        filters = filters,
        id = id,
        name = name,
        tags = tags,
    )
}
