@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetManagedPrefixListsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getManagedPrefixLists.
 * @property filters Custom filter block as described below.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired .
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetManagedPrefixListsPlainArgs(
    public val filters: List<GetManagedPrefixListsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetManagedPrefixListsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetManagedPrefixListsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetManagedPrefixListsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetManagedPrefixListsPlainArgs].
 */
@PulumiTagMarker
public class GetManagedPrefixListsPlainArgsBuilder internal constructor() {
    private var filters: List<GetManagedPrefixListsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("wnsujpjgisrgtdar")
    public suspend fun filters(`value`: List<GetManagedPrefixListsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("iuilkoqrdcpjoidr")
    public suspend fun filters(argument: List<suspend GetManagedPrefixListsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetManagedPrefixListsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("vcbtkqoxykvliadx")
    public suspend fun filters(vararg argument: suspend GetManagedPrefixListsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetManagedPrefixListsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("mfgjpxtbqjnrvosb")
    public suspend fun filters(argument: suspend GetManagedPrefixListsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetManagedPrefixListsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("mfcuausaxjhvcqwv")
    public suspend fun filters(vararg values: GetManagedPrefixListsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired .
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("etsjujkdnyworyjp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired .
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("xwjtmufukshknihk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetManagedPrefixListsPlainArgs = GetManagedPrefixListsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
