@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetNatGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNatGateway.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property id ID of the specific NAT Gateway to retrieve.
 * @property state State of the NAT Gateway (pending | failed | available | deleting | deleted ).
 * @property subnetId ID of subnet that the NAT Gateway resides in.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired NAT Gateway.
 * @property vpcId ID of the VPC that the NAT Gateway resides in.
 */
public data class GetNatGatewayPlainArgs(
    public val filters: List<GetNatGatewayFilter>? = null,
    public val id: String? = null,
    public val state: String? = null,
    public val subnetId: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetNatGatewayPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetNatGatewayPlainArgs =
        com.pulumi.aws.ec2.inputs.GetNatGatewayPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .subnetId(subnetId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNatGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetNatGatewayPlainArgsBuilder internal constructor() {
    private var filters: List<GetNatGatewayFilter>? = null

    private var id: String? = null

    private var state: String? = null

    private var subnetId: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("iniegwcssvjiyiby")
    public suspend fun filters(`value`: List<GetNatGatewayFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("lyvtfsosxgoqfgxw")
    public suspend fun filters(argument: List<suspend GetNatGatewayFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNatGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("qmydvoidajelegvy")
    public suspend fun filters(vararg argument: suspend GetNatGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetNatGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("xpifhhntulgeqpew")
    public suspend fun filters(argument: suspend GetNatGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetNatGatewayFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("axfdooavdskukryl")
    public suspend fun filters(vararg values: GetNatGatewayFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the specific NAT Gateway to retrieve.
     */
    @JvmName("jbdqcrfvobuntcdb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value State of the NAT Gateway (pending | failed | available | deleting | deleted ).
     */
    @JvmName("scvjqeiuvnjigfpy")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value ID of subnet that the NAT Gateway resides in.
     */
    @JvmName("uyinxdubfjmoocff")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subnetId = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired NAT Gateway.
     */
    @JvmName("yhojvpcwdiolbqay")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired NAT Gateway.
     */
    @JvmName("olyvgwmcqkrlvxlt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value ID of the VPC that the NAT Gateway resides in.
     */
    @JvmName("ihkthppbdtydkmxb")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetNatGatewayPlainArgs = GetNatGatewayPlainArgs(
        filters = filters,
        id = id,
        state = state,
        subnetId = subnetId,
        tags = tags,
        vpcId = vpcId,
    )
}
