@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetNetworkInsightsPathPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworkInsightsPath.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property networkInsightsPathId ID of the Network Insights Path to select.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetNetworkInsightsPathPlainArgs(
    public val filters: List<GetNetworkInsightsPathFilter>? = null,
    public val networkInsightsPathId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetNetworkInsightsPathPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetNetworkInsightsPathPlainArgs =
        com.pulumi.aws.ec2.inputs.GetNetworkInsightsPathPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .networkInsightsPathId(networkInsightsPathId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetNetworkInsightsPathPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInsightsPathPlainArgsBuilder internal constructor() {
    private var filters: List<GetNetworkInsightsPathFilter>? = null

    private var networkInsightsPathId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("xmsvtyxujeqnanmt")
    public suspend fun filters(`value`: List<GetNetworkInsightsPathFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("qbnymjesluoapcpo")
    public suspend fun filters(argument: List<suspend GetNetworkInsightsPathFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNetworkInsightsPathFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("bvbungdjhegkbqwq")
    public suspend fun filters(vararg argument: suspend GetNetworkInsightsPathFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetNetworkInsightsPathFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("cmwqebrxjsbmvgob")
    public suspend fun filters(argument: suspend GetNetworkInsightsPathFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetNetworkInsightsPathFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ukyntkpxyfybjkqx")
    public suspend fun filters(vararg values: GetNetworkInsightsPathFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the Network Insights Path to select.
     */
    @JvmName("tessxkmpirhhmrrc")
    public suspend fun networkInsightsPathId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkInsightsPathId = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("kqpppcaxfgvmhwhy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("dnvwflkhkdqggxed")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetNetworkInsightsPathPlainArgs = GetNetworkInsightsPathPlainArgs(
        filters = filters,
        networkInsightsPathId = networkInsightsPathId,
        tags = tags,
    )
}
