@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetPrefixListPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPrefixList.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property name Name of the prefix list to select.
 * @property prefixListId ID of the prefix list to select.
 */
public data class GetPrefixListPlainArgs(
    public val filters: List<GetPrefixListFilter>? = null,
    public val name: String? = null,
    public val prefixListId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetPrefixListPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetPrefixListPlainArgs =
        com.pulumi.aws.ec2.inputs.GetPrefixListPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name?.let({ args0 -> args0 }))
            .prefixListId(prefixListId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrefixListPlainArgs].
 */
@PulumiTagMarker
public class GetPrefixListPlainArgsBuilder internal constructor() {
    private var filters: List<GetPrefixListFilter>? = null

    private var name: String? = null

    private var prefixListId: String? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("nyjonwtbnaapyjfi")
    public suspend fun filters(`value`: List<GetPrefixListFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("pygxnhcwlewnwlse")
    public suspend fun filters(argument: List<suspend GetPrefixListFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPrefixListFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("nydqbymhleosypeo")
    public suspend fun filters(vararg argument: suspend GetPrefixListFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPrefixListFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("jmcvnyrthppemiqk")
    public suspend fun filters(argument: suspend GetPrefixListFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetPrefixListFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("lqbfgkersejwruiq")
    public suspend fun filters(vararg values: GetPrefixListFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Name of the prefix list to select.
     */
    @JvmName("blglnwajaamsupih")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value ID of the prefix list to select.
     */
    @JvmName("ohitnuwmlkfosfha")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.prefixListId = mapped
    }

    internal fun build(): GetPrefixListPlainArgs = GetPrefixListPlainArgs(
        filters = filters,
        name = name,
        prefixListId = prefixListId,
    )
}
