@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPublicIpv4Pools.
 * @property filters Custom filter block as described below.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired pools.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetPublicIpv4PoolsPlainArgs(
    public val filters: List<GetPublicIpv4PoolsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPublicIpv4PoolsPlainArgs].
 */
@PulumiTagMarker
public class GetPublicIpv4PoolsPlainArgsBuilder internal constructor() {
    private var filters: List<GetPublicIpv4PoolsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("jjknibfrpqwgnyll")
    public suspend fun filters(`value`: List<GetPublicIpv4PoolsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("hhhvbcudeotwwdrm")
    public suspend fun filters(argument: List<suspend GetPublicIpv4PoolsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPublicIpv4PoolsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("sdegbrtbwxsegpso")
    public suspend fun filters(vararg argument: suspend GetPublicIpv4PoolsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPublicIpv4PoolsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("iiglostevcumeyto")
    public suspend fun filters(argument: suspend GetPublicIpv4PoolsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetPublicIpv4PoolsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("udvhrwrohywpmmil")
    public suspend fun filters(vararg values: GetPublicIpv4PoolsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired pools.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("ayvrsvlnkilydlym")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired pools.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("huivftuprxayvtjh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPublicIpv4PoolsPlainArgs = GetPublicIpv4PoolsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
