@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetRouteTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteTable.
 * @property filters Configuration block. Detailed below.
 * @property gatewayId ID of an Internet Gateway or Virtual Private Gateway which is connected to the Route Table (not exported if not passed as a parameter).
 * @property routeTableId ID of the specific Route Table to retrieve.
 * @property subnetId ID of a Subnet which is connected to the Route Table (not exported if not passed as a parameter).
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired Route Table.
 * @property vpcId ID of the VPC that the desired Route Table belongs to.
 */
public data class GetRouteTablePlainArgs(
    public val filters: List<GetRouteTableFilter>? = null,
    public val gatewayId: String? = null,
    public val routeTableId: String? = null,
    public val subnetId: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetRouteTablePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetRouteTablePlainArgs =
        com.pulumi.aws.ec2.inputs.GetRouteTablePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .gatewayId(gatewayId?.let({ args0 -> args0 }))
            .routeTableId(routeTableId?.let({ args0 -> args0 }))
            .subnetId(subnetId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteTablePlainArgs].
 */
@PulumiTagMarker
public class GetRouteTablePlainArgsBuilder internal constructor() {
    private var filters: List<GetRouteTableFilter>? = null

    private var gatewayId: String? = null

    private var routeTableId: String? = null

    private var subnetId: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("wingssmhybaguacu")
    public suspend fun filters(`value`: List<GetRouteTableFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("wanvwhsrhprltaha")
    public suspend fun filters(argument: List<suspend GetRouteTableFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetRouteTableFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("emaocbqqblahjpue")
    public suspend fun filters(vararg argument: suspend GetRouteTableFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetRouteTableFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("ffclnbnxwwuwnasp")
    public suspend fun filters(argument: suspend GetRouteTableFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetRouteTableFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("ysdtdcrfkcapgjmb")
    public suspend fun filters(vararg values: GetRouteTableFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of an Internet Gateway or Virtual Private Gateway which is connected to the Route Table (not exported if not passed as a parameter).
     */
    @JvmName("qnmyqeeqextapssa")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gatewayId = mapped
    }

    /**
     * @param value ID of the specific Route Table to retrieve.
     */
    @JvmName("qwrltqqppihdbnur")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routeTableId = mapped
    }

    /**
     * @param value ID of a Subnet which is connected to the Route Table (not exported if not passed as a parameter).
     */
    @JvmName("utoaniraaoqacsat")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subnetId = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired Route Table.
     */
    @JvmName("wutkwuwgoqtouaql")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired Route Table.
     */
    @JvmName("svoikmowdbndnscu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value ID of the VPC that the desired Route Table belongs to.
     */
    @JvmName("bthlojjdktnbujqf")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetRouteTablePlainArgs = GetRouteTablePlainArgs(
        filters = filters,
        gatewayId = gatewayId,
        routeTableId = routeTableId,
        subnetId = subnetId,
        tags = tags,
        vpcId = vpcId,
    )
}
