@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetSecurityGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecurityGroups.
 * @property filters One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out [describe-security-groups in the AWS CLI reference][1].
 * @property tags Map of tags, each pair of which must exactly match for desired security groups.
 */
public data class GetSecurityGroupsPlainArgs(
    public val filters: List<GetSecurityGroupsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetSecurityGroupsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetSecurityGroupsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetSecurityGroupsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSecurityGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityGroupsPlainArgsBuilder internal constructor() {
    private var filters: List<GetSecurityGroupsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out [describe-security-groups in the AWS CLI reference][1].
     */
    @JvmName("dtcxuflmprgcygbx")
    public suspend fun filters(`value`: List<GetSecurityGroupsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out [describe-security-groups in the AWS CLI reference][1].
     */
    @JvmName("qhftbmtpgoamwjgs")
    public suspend fun filters(argument: List<suspend GetSecurityGroupsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSecurityGroupsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out [describe-security-groups in the AWS CLI reference][1].
     */
    @JvmName("syvjalqwnftaciyg")
    public suspend fun filters(vararg argument: suspend GetSecurityGroupsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSecurityGroupsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out [describe-security-groups in the AWS CLI reference][1].
     */
    @JvmName("uwloryaeuslvbwkn")
    public suspend fun filters(argument: suspend GetSecurityGroupsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSecurityGroupsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out [describe-security-groups in the AWS CLI reference][1].
     */
    @JvmName("nbcwkxouawxcsenf")
    public suspend fun filters(vararg values: GetSecurityGroupsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match for desired security groups.
     */
    @JvmName("okbkwvpljxvsiwsj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match for desired security groups.
     */
    @JvmName("maojscmgtddqgmnc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSecurityGroupsPlainArgs = GetSecurityGroupsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
