@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetSpotPricePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSpotPrice.
 * @property availabilityZone Availability zone in which to query Spot price information.
 * @property filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html) for supported filters. Detailed below.
 * @property instanceType Type of instance for which to query Spot Price information.
 */
public data class GetSpotPricePlainArgs(
    public val availabilityZone: String? = null,
    public val filters: List<GetSpotPriceFilter>? = null,
    public val instanceType: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetSpotPricePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetSpotPricePlainArgs =
        com.pulumi.aws.ec2.inputs.GetSpotPricePlainArgs.builder()
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .instanceType(instanceType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSpotPricePlainArgs].
 */
@PulumiTagMarker
public class GetSpotPricePlainArgsBuilder internal constructor() {
    private var availabilityZone: String? = null

    private var filters: List<GetSpotPriceFilter>? = null

    private var instanceType: String? = null

    /**
     * @param value Availability zone in which to query Spot price information.
     */
    @JvmName("yymsbdolsxihijmg")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html) for supported filters. Detailed below.
     */
    @JvmName("raqbctbnuvyokprc")
    public suspend fun filters(`value`: List<GetSpotPriceFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html) for supported filters. Detailed below.
     */
    @JvmName("tvjigvoekgpidxtp")
    public suspend fun filters(argument: List<suspend GetSpotPriceFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSpotPriceFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html) for supported filters. Detailed below.
     */
    @JvmName("bnjikuhbpdntneve")
    public suspend fun filters(vararg argument: suspend GetSpotPriceFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSpotPriceFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html) for supported filters. Detailed below.
     */
    @JvmName("cvgljxpomtcwxmrv")
    public suspend fun filters(argument: suspend GetSpotPriceFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSpotPriceFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html) for supported filters. Detailed below.
     */
    @JvmName("tfoucyfhdlrhufus")
    public suspend fun filters(vararg values: GetSpotPriceFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Type of instance for which to query Spot Price information.
     */
    @JvmName("mjvhqxktogepgfud")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    internal fun build(): GetSpotPricePlainArgs = GetSpotPricePlainArgs(
        availabilityZone = availabilityZone,
        filters = filters,
        instanceType = instanceType,
    )
}
