@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetSubnetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSubnets.
 * @property filters Custom filter block as described below.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired subnets.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetSubnetsPlainArgs(
    public val filters: List<GetSubnetsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetSubnetsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetSubnetsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetSubnetsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSubnetsPlainArgs].
 */
@PulumiTagMarker
public class GetSubnetsPlainArgsBuilder internal constructor() {
    private var filters: List<GetSubnetsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("juroiaweseitrypk")
    public suspend fun filters(`value`: List<GetSubnetsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("uxltjkowyeuaddxc")
    public suspend fun filters(argument: List<suspend GetSubnetsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSubnetsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("yigpbwshpjtbsudn")
    public suspend fun filters(vararg argument: suspend GetSubnetsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSubnetsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("sqdfekxxpyaibagf")
    public suspend fun filters(argument: suspend GetSubnetsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSubnetsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("vfnmhyjsvlqultjj")
    public suspend fun filters(vararg values: GetSubnetsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired subnets.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("asdgebdffyukrhvc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired subnets.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("rlwtloriiadsidko")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSubnetsPlainArgs = GetSubnetsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
