@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcEndpointServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpointService.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property service Common name of an AWS service (e.g., `s3`).
 * @property serviceName Service name that is specified when creating a VPC endpoint. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
 * @property serviceType Service type, `Gateway` or `Interface`.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired VPC Endpoint Service.
 * > **NOTE:** Specifying `service` will not work for non-AWS services or AWS services that don't follow the standard `service_name` pattern of `com.amazonaws.<region>.<service>`.
 */
public data class GetVpcEndpointServicePlainArgs(
    public val filters: List<GetVpcEndpointServiceFilter>? = null,
    public val service: String? = null,
    public val serviceName: String? = null,
    public val serviceType: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcEndpointServicePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcEndpointServicePlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcEndpointServicePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .service(service?.let({ args0 -> args0 }))
            .serviceName(serviceName?.let({ args0 -> args0 }))
            .serviceType(serviceType?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcEndpointServicePlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointServicePlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcEndpointServiceFilter>? = null

    private var service: String? = null

    private var serviceName: String? = null

    private var serviceType: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("yscmcnuvvekfnipv")
    public suspend fun filters(`value`: List<GetVpcEndpointServiceFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("jqifnbkhsrwtpisu")
    public suspend fun filters(argument: List<suspend GetVpcEndpointServiceFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcEndpointServiceFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("jwppyfjjhqcebeyk")
    public suspend fun filters(vararg argument: suspend GetVpcEndpointServiceFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcEndpointServiceFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("werwicadqnbfgvbq")
    public suspend fun filters(argument: suspend GetVpcEndpointServiceFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetVpcEndpointServiceFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("lokqdbndmekpnapn")
    public suspend fun filters(vararg values: GetVpcEndpointServiceFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Common name of an AWS service (e.g., `s3`).
     */
    @JvmName("jspjbcrixaefdshd")
    public suspend fun service(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.service = mapped
    }

    /**
     * @param value Service name that is specified when creating a VPC endpoint. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     */
    @JvmName("stqrroilgfpksqsa")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Service type, `Gateway` or `Interface`.
     */
    @JvmName("osgvynhuyuxmmbyk")
    public suspend fun serviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceType = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired VPC Endpoint Service.
     * > **NOTE:** Specifying `service` will not work for non-AWS services or AWS services that don't follow the standard `service_name` pattern of `com.amazonaws.<region>.<service>`.
     */
    @JvmName("kgwxlgrjwitynnrk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired VPC Endpoint Service.
     * > **NOTE:** Specifying `service` will not work for non-AWS services or AWS services that don't follow the standard `service_name` pattern of `com.amazonaws.<region>.<service>`.
     */
    @JvmName("tottcicmrqlyghcq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcEndpointServicePlainArgs = GetVpcEndpointServicePlainArgs(
        filters = filters,
        service = service,
        serviceName = serviceName,
        serviceType = serviceType,
        tags = tags,
    )
}
