@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcIamPoolCidrsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcIamPoolCidrs.
 * @property filters Custom filter block as described below.
 * @property ipamPoolId ID of the IPAM pool you would like the list of provisioned CIDRs.
 */
public data class GetVpcIamPoolCidrsPlainArgs(
    public val filters: List<GetVpcIamPoolCidrsFilter>? = null,
    public val ipamPoolId: String,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcIamPoolCidrsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcIamPoolCidrsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcIamPoolCidrsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ipamPoolId(ipamPoolId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcIamPoolCidrsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcIamPoolCidrsPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcIamPoolCidrsFilter>? = null

    private var ipamPoolId: String? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("ibxdmtccrsljhoui")
    public suspend fun filters(`value`: List<GetVpcIamPoolCidrsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("lnqnuktqwfidyqur")
    public suspend fun filters(argument: List<suspend GetVpcIamPoolCidrsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcIamPoolCidrsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("ripefpjagrcxjuym")
    public suspend fun filters(vararg argument: suspend GetVpcIamPoolCidrsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcIamPoolCidrsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("oqktyquwdrbfyyjv")
    public suspend fun filters(argument: suspend GetVpcIamPoolCidrsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcIamPoolCidrsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("khgplnphaxjhelsh")
    public suspend fun filters(vararg values: GetVpcIamPoolCidrsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the IPAM pool you would like the list of provisioned CIDRs.
     */
    @JvmName("rymsqhvghiodkxhc")
    public suspend fun ipamPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipamPoolId = mapped
    }

    internal fun build(): GetVpcIamPoolCidrsPlainArgs = GetVpcIamPoolCidrsPlainArgs(
        filters = filters,
        ipamPoolId = ipamPoolId ?: throw PulumiNullFieldException("ipamPoolId"),
    )
}
