@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcIamPoolsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcIamPools.
 * @property filters Custom filter block as described below.
 */
public data class GetVpcIamPoolsPlainArgs(
    public val filters: List<GetVpcIamPoolsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcIamPoolsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcIamPoolsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcIamPoolsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetVpcIamPoolsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcIamPoolsPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcIamPoolsFilter>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("xxetwgllbueekmue")
    public suspend fun filters(`value`: List<GetVpcIamPoolsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("hbnsuyrdsdclvenj")
    public suspend fun filters(argument: List<suspend GetVpcIamPoolsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcIamPoolsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("ufafpbdksgtnyhme")
    public suspend fun filters(vararg argument: suspend GetVpcIamPoolsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcIamPoolsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("tgibosmdyjgwhelh")
    public suspend fun filters(argument: suspend GetVpcIamPoolsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcIamPoolsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("nndaqputbggwmecw")
    public suspend fun filters(vararg values: GetVpcIamPoolsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetVpcIamPoolsPlainArgs = GetVpcIamPoolsPlainArgs(
        filters = filters,
    )
}
