@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolCidrsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcIpamPoolCidrs.
 * @property filters Custom filter block as described below.
 * @property ipamPoolId ID of the IPAM pool you would like the list of provisioned CIDRs.
 */
public data class GetVpcIpamPoolCidrsPlainArgs(
    public val filters: List<GetVpcIpamPoolCidrsFilter>? = null,
    public val ipamPoolId: String,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcIpamPoolCidrsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcIpamPoolCidrsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcIpamPoolCidrsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ipamPoolId(ipamPoolId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcIpamPoolCidrsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcIpamPoolCidrsPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcIpamPoolCidrsFilter>? = null

    private var ipamPoolId: String? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("clnvkteourgwudmy")
    public suspend fun filters(`value`: List<GetVpcIpamPoolCidrsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("wnaguhwhjhuwjoyu")
    public suspend fun filters(argument: List<suspend GetVpcIpamPoolCidrsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcIpamPoolCidrsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("woykusogckrxfgti")
    public suspend fun filters(vararg argument: suspend GetVpcIpamPoolCidrsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcIpamPoolCidrsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("qgkpwofljwjfivgj")
    public suspend fun filters(argument: suspend GetVpcIpamPoolCidrsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcIpamPoolCidrsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("utgcgnifbeuqonus")
    public suspend fun filters(vararg values: GetVpcIpamPoolCidrsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the IPAM pool you would like the list of provisioned CIDRs.
     */
    @JvmName("waxvkvcyduqvvhfj")
    public suspend fun ipamPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipamPoolId = mapped
    }

    internal fun build(): GetVpcIpamPoolCidrsPlainArgs = GetVpcIpamPoolCidrsPlainArgs(
        filters = filters,
        ipamPoolId = ipamPoolId ?: throw PulumiNullFieldException("ipamPoolId"),
    )
}
