@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcIpamPools.
 * @property filters Custom filter block as described below.
 */
public data class GetVpcIpamPoolsPlainArgs(
    public val filters: List<GetVpcIpamPoolsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcIpamPoolsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcIpamPoolsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcIpamPoolsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetVpcIpamPoolsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcIpamPoolsPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcIpamPoolsFilter>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("nkjthofpfrmkuwhx")
    public suspend fun filters(`value`: List<GetVpcIpamPoolsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("xeyeoegkvtktijyl")
    public suspend fun filters(argument: List<suspend GetVpcIpamPoolsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcIpamPoolsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("bybqvamlaxftsnpb")
    public suspend fun filters(vararg argument: suspend GetVpcIpamPoolsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcIpamPoolsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("ibygjeqyymrihxwx")
    public suspend fun filters(argument: suspend GetVpcIpamPoolsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcIpamPoolsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("yskxoosgwxygmkad")
    public suspend fun filters(vararg values: GetVpcIpamPoolsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetVpcIpamPoolsPlainArgs = GetVpcIpamPoolsPlainArgs(
        filters = filters,
    )
}
