@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcs.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired vpcs.
 */
public data class GetVpcsPlainArgs(
    public val filters: List<GetVpcsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcsPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("tkrvufhknsytsbqx")
    public suspend fun filters(`value`: List<GetVpcsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("cqoptrrbptnnuafc")
    public suspend fun filters(argument: List<suspend GetVpcsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetVpcsFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("aommmfbrhtycjten")
    public suspend fun filters(vararg argument: suspend GetVpcsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetVpcsFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("anvhngvybyyugncu")
    public suspend fun filters(argument: suspend GetVpcsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("lyyatsqvuyompxfm")
    public suspend fun filters(vararg values: GetVpcsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired vpcs.
     */
    @JvmName("keudralrifytdohk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired vpcs.
     */
    @JvmName("aevkbgwdyvpuvgot")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcsPlainArgs = GetVpcsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
