@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpnGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpnGateway.
 * @property amazonSideAsn Autonomous System Number (ASN) for the Amazon side of the specific VPN Gateway to retrieve.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property attachedVpcId ID of a VPC attached to the specific VPN Gateway to retrieve.
 * @property availabilityZone Availability Zone of the specific VPN Gateway to retrieve.
 * @property filters Custom filter block as described below.
 * @property id ID of the specific VPN Gateway to retrieve.
 * @property state State of the specific VPN Gateway to retrieve.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired VPN Gateway.
 */
public data class GetVpnGatewayPlainArgs(
    public val amazonSideAsn: String? = null,
    public val attachedVpcId: String? = null,
    public val availabilityZone: String? = null,
    public val filters: List<GetVpnGatewayFilter>? = null,
    public val id: String? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpnGatewayPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpnGatewayPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpnGatewayPlainArgs.builder()
            .amazonSideAsn(amazonSideAsn?.let({ args0 -> args0 }))
            .attachedVpcId(attachedVpcId?.let({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpnGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetVpnGatewayPlainArgsBuilder internal constructor() {
    private var amazonSideAsn: String? = null

    private var attachedVpcId: String? = null

    private var availabilityZone: String? = null

    private var filters: List<GetVpnGatewayFilter>? = null

    private var id: String? = null

    private var state: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Autonomous System Number (ASN) for the Amazon side of the specific VPN Gateway to retrieve.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("epvsgpmuwlkfouex")
    public suspend fun amazonSideAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.amazonSideAsn = mapped
    }

    /**
     * @param value ID of a VPC attached to the specific VPN Gateway to retrieve.
     */
    @JvmName("cjvajfujxfaqgyhq")
    public suspend fun attachedVpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.attachedVpcId = mapped
    }

    /**
     * @param value Availability Zone of the specific VPN Gateway to retrieve.
     */
    @JvmName("qildaobtsrgxykxg")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("smhlslhvmioojtvc")
    public suspend fun filters(`value`: List<GetVpnGatewayFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("kwjekmlxdumjmyoh")
    public suspend fun filters(argument: List<suspend GetVpnGatewayFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpnGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("adhbxhvscxecofit")
    public suspend fun filters(vararg argument: suspend GetVpnGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpnGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("ojhtbyxbpbrhkxtb")
    public suspend fun filters(argument: suspend GetVpnGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpnGatewayFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("dctorevqbydhtdnw")
    public suspend fun filters(vararg values: GetVpnGatewayFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the specific VPN Gateway to retrieve.
     */
    @JvmName("htxuaabbfrcdschk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value State of the specific VPN Gateway to retrieve.
     */
    @JvmName("ubyehatxcfgolywv")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired VPN Gateway.
     */
    @JvmName("mprnwhwpwxypilyb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired VPN Gateway.
     */
    @JvmName("kyofjanthwsyhygp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpnGatewayPlainArgs = GetVpnGatewayPlainArgs(
        amazonSideAsn = amazonSideAsn,
        attachedVpcId = attachedVpcId,
        availabilityZone = availabilityZone,
        filters = filters,
        id = id,
        state = state,
        tags = tags,
    )
}
